/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.message;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.compute.ComputeJobDataHolder;
import org.apache.ignite.internal.compute.ExecutionOptions;
import org.apache.ignite.internal.compute.events.ComputeEventMetadataBuilder;
import org.apache.ignite.internal.compute.message.DeploymentUnitMsg;
import org.apache.ignite.internal.compute.message.ExecuteRequestV2;
import org.apache.ignite.internal.compute.message.ExecuteRequestV2Builder;
import org.apache.ignite.internal.compute.message.ExecuteRequestV2Serializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class ExecuteRequestV2Impl
implements ExecuteRequestV2,
Cloneable {
    public static final short GROUP_TYPE = 6;
    public static final short TYPE = 13;
    @IgniteToStringInclude
    private final List<DeploymentUnitMsg> deploymentUnits;
    @IgniteToStringInclude
    private ExecutionOptions executeOptions;
    private byte[] executeOptionsByteArray;
    @IgniteToStringInclude
    private ComputeJobDataHolder input;
    private byte[] inputByteArray;
    @IgniteToStringInclude
    private final String jobClassName;
    @IgniteToStringInclude
    private ComputeEventMetadataBuilder metadataBuilder;
    private byte[] metadataBuilderByteArray;

    private ExecuteRequestV2Impl(List<DeploymentUnitMsg> deploymentUnits, ExecutionOptions executeOptions, byte[] executeOptionsByteArray, ComputeJobDataHolder input, byte[] inputByteArray, String jobClassName, ComputeEventMetadataBuilder metadataBuilder, byte[] metadataBuilderByteArray) {
        this.deploymentUnits = deploymentUnits;
        if (executeOptions == null && executeOptionsByteArray == null) {
            throw new NullPointerException("executeOptions is not marked @Nullable");
        }
        this.executeOptions = executeOptions;
        this.executeOptionsByteArray = executeOptionsByteArray;
        this.input = input;
        this.inputByteArray = inputByteArray;
        this.jobClassName = jobClassName;
        if (metadataBuilder == null && metadataBuilderByteArray == null) {
            throw new NullPointerException("metadataBuilder is not marked @Nullable");
        }
        this.metadataBuilder = metadataBuilder;
        this.metadataBuilderByteArray = metadataBuilderByteArray;
    }

    @Override
    public List<DeploymentUnitMsg> deploymentUnits() {
        return this.deploymentUnits;
    }

    byte[] executeOptionsByteArray() {
        return this.executeOptionsByteArray;
    }

    @Override
    public ExecutionOptions executeOptions() {
        return this.executeOptions;
    }

    byte[] inputByteArray() {
        return this.inputByteArray;
    }

    @Override
    public ComputeJobDataHolder input() {
        return this.input;
    }

    @Override
    public String jobClassName() {
        return this.jobClassName;
    }

    byte[] metadataBuilderByteArray() {
        return this.metadataBuilderByteArray;
    }

    @Override
    public ComputeEventMetadataBuilder metadataBuilder() {
        return this.metadataBuilder;
    }

    public MessageSerializer serializer() {
        return ExecuteRequestV2Serializer.INSTANCE;
    }

    public short groupType() {
        return 6;
    }

    public String toString() {
        return S.toString(ExecuteRequestV2Impl.class, (Object)this);
    }

    public short messageType() {
        return 13;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ExecuteRequestV2Impl otherMessage = (ExecuteRequestV2Impl)other;
        return Objects.equals(this.deploymentUnits, otherMessage.deploymentUnits) && Objects.equals(this.executeOptions, otherMessage.executeOptions) && Objects.equals(this.input, otherMessage.input) && Objects.equals(this.jobClassName, otherMessage.jobClassName) && Objects.equals(this.metadataBuilder, otherMessage.metadataBuilder);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.deploymentUnits, this.executeOptions, this.input, this.jobClassName, this.metadataBuilder);
        return result;
    }

    public ExecuteRequestV2Impl clone() {
        try {
            return (ExecuteRequestV2Impl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ExecuteRequestV2Builder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.deploymentUnits != null) {
            for (DeploymentUnitMsg obj : this.deploymentUnits) {
                if (obj == null) continue;
                obj.prepareMarshal(usedDescriptors, marshaller);
            }
        }
        MarshalledObject executeOptionsByteArraymo = marshaller.marshal((Object)this.executeOptions);
        usedDescriptors.addAll((IntCollection)executeOptionsByteArraymo.usedDescriptorIds());
        this.executeOptionsByteArray = executeOptionsByteArraymo.bytes();
        MarshalledObject inputByteArraymo = marshaller.marshal((Object)this.input);
        usedDescriptors.addAll((IntCollection)inputByteArraymo.usedDescriptorIds());
        this.inputByteArray = inputByteArraymo.bytes();
        MarshalledObject metadataBuilderByteArraymo = marshaller.marshal((Object)this.metadataBuilder);
        usedDescriptors.addAll((IntCollection)metadataBuilderByteArraymo.usedDescriptorIds());
        this.metadataBuilderByteArray = metadataBuilderByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.deploymentUnits != null) {
            for (DeploymentUnitMsg obj : this.deploymentUnits) {
                if (obj == null) continue;
                obj.unmarshal(marshaller, descriptorsObj);
            }
        }
        this.executeOptions = (ExecutionOptions)marshaller.unmarshal(this.executeOptionsByteArray, descriptorsObj);
        this.executeOptionsByteArray = null;
        this.input = (ComputeJobDataHolder)marshaller.unmarshal(this.inputByteArray, descriptorsObj);
        this.inputByteArray = null;
        this.metadataBuilder = (ComputeEventMetadataBuilder)marshaller.unmarshal(this.metadataBuilderByteArray, descriptorsObj);
        this.metadataBuilderByteArray = null;
    }

    private static class Builder
    implements ExecuteRequestV2Builder {
        private List<DeploymentUnitMsg> deploymentUnits;
        private ExecutionOptions executeOptions;
        private byte[] executeOptionsByteArray;
        private ComputeJobDataHolder input;
        private byte[] inputByteArray;
        private String jobClassName;
        private ComputeEventMetadataBuilder metadataBuilder;
        private byte[] metadataBuilderByteArray;

        private Builder() {
        }

        @Override
        public ExecuteRequestV2Builder deploymentUnits(List<DeploymentUnitMsg> deploymentUnits) {
            Objects.requireNonNull(deploymentUnits, "deploymentUnits is not marked @Nullable");
            this.deploymentUnits = deploymentUnits;
            return this;
        }

        @Override
        public ExecuteRequestV2Builder executeOptions(ExecutionOptions executeOptions) {
            Objects.requireNonNull(executeOptions, "executeOptions is not marked @Nullable");
            this.executeOptions = executeOptions;
            return this;
        }

        @Override
        public ExecuteRequestV2Builder executeOptionsByteArray(byte[] executeOptionsByteArray) {
            this.executeOptionsByteArray = executeOptionsByteArray;
            return this;
        }

        @Override
        public ExecuteRequestV2Builder input(ComputeJobDataHolder input) {
            this.input = input;
            return this;
        }

        @Override
        public ExecuteRequestV2Builder inputByteArray(byte[] inputByteArray) {
            this.inputByteArray = inputByteArray;
            return this;
        }

        @Override
        public ExecuteRequestV2Builder jobClassName(String jobClassName) {
            Objects.requireNonNull(jobClassName, "jobClassName is not marked @Nullable");
            this.jobClassName = jobClassName;
            return this;
        }

        @Override
        public ExecuteRequestV2Builder metadataBuilder(ComputeEventMetadataBuilder metadataBuilder) {
            Objects.requireNonNull(metadataBuilder, "metadataBuilder is not marked @Nullable");
            this.metadataBuilder = metadataBuilder;
            return this;
        }

        @Override
        public ExecuteRequestV2Builder metadataBuilderByteArray(byte[] metadataBuilderByteArray) {
            this.metadataBuilderByteArray = metadataBuilderByteArray;
            return this;
        }

        @Override
        public List<DeploymentUnitMsg> deploymentUnits() {
            return this.deploymentUnits;
        }

        @Override
        public ExecutionOptions executeOptions() {
            return this.executeOptions;
        }

        @Override
        public byte[] executeOptionsByteArray() {
            return this.executeOptionsByteArray;
        }

        @Override
        public ComputeJobDataHolder input() {
            return this.input;
        }

        @Override
        public byte[] inputByteArray() {
            return this.inputByteArray;
        }

        @Override
        public String jobClassName() {
            return this.jobClassName;
        }

        @Override
        public ComputeEventMetadataBuilder metadataBuilder() {
            return this.metadataBuilder;
        }

        @Override
        public byte[] metadataBuilderByteArray() {
            return this.metadataBuilderByteArray;
        }

        @Override
        public ExecuteRequestV2 build() {
            return new ExecuteRequestV2Impl(Objects.requireNonNull(this.deploymentUnits, "deploymentUnits is not marked @Nullable"), this.executeOptions, this.executeOptionsByteArray, this.input, this.inputByteArray, Objects.requireNonNull(this.jobClassName, "jobClassName is not marked @Nullable"), this.metadataBuilder, this.metadataBuilderByteArray);
        }
    }
}

