/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.message.ClassDescriptorMessage;

public class OutNetworkObject {
    private final NetworkMessage networkMessage;
    private final List<ClassDescriptorMessage> descriptors;
    private boolean shouldBeSavedForRecovery;
    private final CompletableFuture<Void> acknowledgedFuture = new CompletableFuture();

    public OutNetworkObject(NetworkMessage networkMessage, List<ClassDescriptorMessage> descriptors) {
        this.networkMessage = networkMessage;
        this.descriptors = descriptors;
        this.shouldBeSavedForRecovery = networkMessage.needAck();
    }

    public boolean shouldBeSavedForRecovery() {
        return this.shouldBeSavedForRecovery;
    }

    public void shouldBeSavedForRecovery(boolean shouldBeSavedForRecovery) {
        this.shouldBeSavedForRecovery = shouldBeSavedForRecovery;
    }

    public NetworkMessage networkMessage() {
        return this.networkMessage;
    }

    public List<ClassDescriptorMessage> descriptors() {
        return this.descriptors;
    }

    public CompletableFuture<Void> acknowledgedFuture() {
        return this.acknowledgedFuture;
    }

    public void acknowledge() {
        this.acknowledgedFuture.complete(null);
    }

    public void failAcknowledgement(Throwable ex) {
        this.acknowledgedFuture.completeExceptionally(ex);
    }
}

