/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.marshalling;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import org.apache.ignite.shaded.org.apache.ignite.marshalling.Marshaller;
import org.apache.ignite.shaded.org.apache.ignite.marshalling.MarshallingException;
import org.apache.ignite.shaded.org.apache.ignite.marshalling.UnsupportedObjectTypeMarshallingException;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;

public interface ByteArrayMarshaller<T>
extends Marshaller<T, byte[]> {
    public static <T> ByteArrayMarshaller<T> create() {
        return new ByteArrayMarshaller<T>(){};
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    default public byte @Nullable [] marshal(@Nullable T object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Serializable) {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                byte[] byArray;
                try (ObjectOutputStream out = new ObjectOutputStream(baos);){
                    out.writeObject(object);
                    out.flush();
                    byArray = baos.toByteArray();
                }
                return byArray;
            }
            catch (IOException e) {
                throw new MarshallingException(e);
            }
        }
        throw new UnsupportedObjectTypeMarshallingException(object.getClass());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    default public T unmarshal(byte @Nullable [] raw) {
        if (raw == null) {
            return null;
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(raw);){
            Object object;
            try (ObjectInputStream ois = new ObjectInputStream(bais){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    String name = desc.getName();
                    try {
                        return Class.forName(name, false, Thread.currentThread().getContextClassLoader());
                    }
                    catch (ClassNotFoundException ex) {
                        return super.resolveClass(desc);
                    }
                }
            };){
                object = ois.readObject();
            }
            return (T)object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new MarshallingException(e);
        }
    }
}

