/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.file;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.guacamole.auth.file.Authorization;
import org.apache.guacamole.protocol.GuacamoleConfiguration;

/*
 * Exception performing whole class analysis ignored.
 */
public class Authorization {
    private String username;
    private String password;
    private Encoding encoding = Encoding.PLAIN_TEXT;
    private Map<String, GuacamoleConfiguration> configs = new TreeMap();
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private static String getHexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            hex.append(HEX_CHARS[(b & 0xF0) >> 4]).append(HEX_CHARS[b & 0xF]);
        }
        return hex.toString();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Encoding encoding) {
        this.encoding = encoding;
    }

    public boolean validate(String username, String password) {
        if (username != null && password != null && username.equals(this.username)) {
            switch (this.encoding.ordinal()) {
                case 0: {
                    return password.equals(this.password);
                }
                case 1: {
                    try {
                        MessageDigest digest = MessageDigest.getInstance("MD5");
                        String hashedPassword = Authorization.getHexString((byte[])digest.digest(password.getBytes("UTF-8")));
                        return hashedPassword.equals(this.password.toUpperCase());
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new UnsupportedOperationException("Unexpected lack of UTF-8 support.", e);
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new UnsupportedOperationException("Unexpected lack of MD5 support.", e);
                    }
                }
                case 2: {
                    try {
                        MessageDigest digest = MessageDigest.getInstance("SHA-256");
                        String hashedPassword = Authorization.getHexString((byte[])digest.digest(password.getBytes("UTF-8")));
                        return hashedPassword.equals(this.password.toUpperCase());
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new UnsupportedOperationException("Unexpected lack of UTF-8 support.", e);
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new UnsupportedOperationException("Unexpected lack of SHA-256 support.", e);
                    }
                }
            }
        }
        return false;
    }

    public GuacamoleConfiguration getConfiguration(String name) {
        return (GuacamoleConfiguration)this.configs.get(name);
    }

    public void addConfiguration(String name, GuacamoleConfiguration config) {
        this.configs.put(name, config);
    }

    public Map<String, GuacamoleConfiguration> getConfigurations() {
        return this.configs;
    }
}

