/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.core.impl.scheduling.cron.embedded;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.felix.hc.core.impl.scheduling.cron.embedded.AsyncEmbeddedCronJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EmbeddedCronScheduler
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedCronScheduler.class);
    private final Map<String, AsyncEmbeddedCronJob> tasks = new ConcurrentHashMap<String, AsyncEmbeddedCronJob>();
    public final ScheduledExecutorService scheduledExecutorService;
    private String schedulerThreadName;

    public EmbeddedCronScheduler(ScheduledExecutorService scheduledExecutorService, long initialDelay, long checkInterval, TimeUnit timeUnit, String schedulerThreadName) {
        this.scheduledExecutorService = scheduledExecutorService;
        scheduledExecutorService.scheduleAtFixedRate(this, initialDelay, checkInterval, timeUnit);
        this.schedulerThreadName = schedulerThreadName;
    }

    public void schedule(AsyncEmbeddedCronJob cronJob) {
        this.tasks.put(cronJob.getId(), cronJob);
    }

    public void remove(AsyncEmbeddedCronJob cronJob) {
        this.tasks.remove(cronJob.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String threadNameToRestore = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName(this.schedulerThreadName);
            LOG.trace("tasks: {}", this.tasks);
            for (Map.Entry<String, AsyncEmbeddedCronJob> entry : this.tasks.entrySet()) {
                AsyncEmbeddedCronJob job = entry.getValue();
                job.checkAndExecute(this.scheduledExecutorService);
            }
        }
        finally {
            Thread.currentThread().setName(threadNameToRestore);
        }
    }
}

