/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapservers.apacheds;

import org.apache.directory.studio.common.core.jobs.StudioRunnableWithProgress;
import org.apache.directory.studio.ldapservers.apacheds.ExtensionUtils;
import org.apache.directory.studio.ldapservers.apacheds.RepairRunnable;
import org.apache.directory.studio.ldapservers.jobs.StudioLdapServerJob;
import org.apache.directory.studio.ldapservers.model.LdapServer;
import org.apache.directory.studio.ldapservers.model.LdapServerStatus;
import org.apache.directory.studio.ldapservers.views.ServersView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class RepairAction
implements IObjectActionDelegate {
    private ServersView view;

    public void run(IAction action) {
        LdapServer server = this.getSelectedServer();
        if (server != null) {
            if (!ExtensionUtils.verifyApacheDs200OrPrintError(server, this.view)) {
                return;
            }
            StudioLdapServerJob job = new StudioLdapServerJob(new StudioRunnableWithProgress[]{new RepairRunnable(server)});
            job.schedule();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        LdapServer server = this.getSelectedServer();
        action.setEnabled(server != null && server.getStatus() == LdapServerStatus.STOPPED);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        if (targetPart instanceof ServersView) {
            this.view = (ServersView)targetPart;
        }
    }

    private LdapServer getSelectedServer() {
        StructuredSelection selection;
        if (this.view != null && !(selection = (StructuredSelection)this.view.getViewer().getSelection()).isEmpty() && selection.size() == 1) {
            LdapServer server = (LdapServer)selection.getFirstElement();
            return server;
        }
        return null;
    }
}

