/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.EmptyCompactSketch;
import org.apache.datasketches.theta.SingleItemSketch;
import org.apache.datasketches.thetacommon.ThetaUtil;

public class BackwardConversions {
    public static Memory convertSerVer3toSerVer1(CompactSketch skV3) {
        boolean validIn;
        boolean bl = validIn = skV3.isCompact() && skV3.isOrdered() && !skV3.hasMemory();
        if (!validIn) {
            throw new SketchesArgumentException("Invalid input sketch.");
        }
        int curCount = skV3.getRetainedEntries(true);
        WritableMemory wmem = WritableMemory.allocate((int)(3 + curCount << 3));
        wmem.putByte(0L, (byte)3);
        wmem.putByte(1L, (byte)1);
        wmem.putByte(2L, (byte)3);
        wmem.putByte(6L, (byte)2);
        wmem.putInt(8L, curCount);
        wmem.putLong(16L, skV3.getThetaLong());
        if (curCount > 0) {
            wmem.putLongArray(24L, skV3.getCache(), 0, curCount);
        }
        return wmem;
    }

    public static Memory convertSerVer3toSerVer2(CompactSketch skV3, long seed) {
        short seedHash = ThetaUtil.computeSeedHash((long)seed);
        WritableMemory wmem = null;
        if (skV3 instanceof EmptyCompactSketch) {
            wmem = WritableMemory.allocate((int)8);
            wmem.putByte(0L, (byte)1);
            wmem.putByte(1L, (byte)2);
            wmem.putByte(2L, (byte)3);
            int flags = 14;
            wmem.putByte(5L, (byte)14);
            wmem.putShort(6L, seedHash);
            return wmem;
        }
        if (skV3 instanceof SingleItemSketch) {
            SingleItemSketch sis = (SingleItemSketch)skV3;
            wmem = WritableMemory.allocate((int)24);
            wmem.putByte(0L, (byte)2);
            wmem.putByte(1L, (byte)2);
            wmem.putByte(2L, (byte)3);
            int flags = 10;
            wmem.putByte(5L, (byte)10);
            wmem.putShort(6L, seedHash);
            wmem.putInt(8L, 1);
            long[] arr = sis.getCache();
            wmem.putLong(16L, arr[0]);
            return wmem;
        }
        int preLongs = skV3.getCompactPreambleLongs();
        int entries = skV3.getRetainedEntries(true);
        boolean unordered = !skV3.isOrdered();
        byte flags = (byte)(0xA | (unordered ? 16 : 0));
        wmem = WritableMemory.allocate((int)(preLongs + entries << 3));
        wmem.putByte(0L, (byte)preLongs);
        wmem.putByte(1L, (byte)2);
        wmem.putByte(2L, (byte)3);
        wmem.putByte(5L, flags);
        wmem.putShort(6L, seedHash);
        wmem.putInt(8L, entries);
        if (preLongs == 3) {
            wmem.putLong(16L, skV3.getThetaLong());
        }
        long[] arr = skV3.getCache();
        wmem.putLongArray((long)preLongs * 8L, arr, 0, entries);
        return wmem;
    }
}

