/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.crypto.pem;

import de.dentrassi.crypto.pem.AbstractMutablePemKeyStore;
import de.dentrassi.crypto.pem.AbstractPemKeyStore;
import de.dentrassi.crypto.pem.AbstractReadOnlyKeyStore;
import de.dentrassi.crypto.pem.PemUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Map;

public final class PemKeyStore {
    private PemKeyStore() {
    }

    public static final class Mutable
    extends AbstractMutablePemKeyStore {
        @Override
        protected Map<String, AbstractPemKeyStore.Entry> load(InputStream stream) throws IOException, NoSuchAlgorithmException, CertificateException {
            return PemUtils.loadFrom(stream, true);
        }
    }

    public static final class Immutable
    extends AbstractReadOnlyKeyStore {
        @Override
        protected Map<String, AbstractPemKeyStore.Entry> load(InputStream stream) throws IOException, NoSuchAlgorithmException, CertificateException {
            return PemUtils.loadFrom(stream, true);
        }
    }
}

