/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.iteration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.wildfly.common.iteration.CompositeIterator;

public class CompositeIterable<T>
implements Iterable<T> {
    private final List<? extends Iterable<? extends T>> iterables;

    @SafeVarargs
    public CompositeIterable(Iterable<? extends T> ... iterables) {
        this(Arrays.asList(iterables));
    }

    public CompositeIterable(List<? extends Iterable<? extends T>> iterables) {
        this.iterables = iterables;
    }

    @Override
    public Iterator<T> iterator() {
        ArrayList<Iterator<? extends T>> iterators = new ArrayList<Iterator<? extends T>>(this.iterables.size());
        for (Iterable<T> elements : this.iterables) {
            iterators.add(elements.iterator());
        }
        return new CompositeIterator(iterators);
    }

    public int hashCode() {
        int result = 1;
        for (Iterable<T> elements : this.iterables) {
            for (T element : elements) {
                result = 31 * result + (element != null ? element.hashCode() : 0);
            }
        }
        return result;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Iterable)) {
            return false;
        }
        Iterator otherElements = ((Iterable)object).iterator();
        for (Iterable<T> iterable : this.iterables) {
            Iterator<T> elements = iterable.iterator();
            while (elements.hasNext() && otherElements.hasNext()) {
                elements.next().equals(otherElements.next());
            }
            if (!elements.hasNext()) continue;
            return false;
        }
        return !otherElements.hasNext();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        Iterator<Iterable<T>> iterables = this.iterables.iterator();
        while (iterables.hasNext()) {
            Iterator<T> elements = iterables.next().iterator();
            while (elements.hasNext()) {
                if (builder.length() > 1) {
                    builder.append(',').append(' ');
                }
                builder.append(elements.next());
            }
        }
        return builder.append(']').toString();
    }
}

