/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import junit.framework.TestSuite;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.ByteConverter;
import org.apache.commons.beanutils.converters.NumberConverter;
import org.apache.commons.beanutils.converters.NumberConverterTestBase;

public class ByteConverterTestCase
extends NumberConverterTestBase {
    private Converter converter;

    public static TestSuite suite() {
        return new TestSuite(ByteConverterTestCase.class);
    }

    public ByteConverterTestCase(String name) {
        super(name);
    }

    @Override
    protected Class<?> getExpectedType() {
        return Byte.class;
    }

    @Override
    protected NumberConverter makeConverter() {
        return new ByteConverter();
    }

    @Override
    protected NumberConverter makeConverter(Object defaultValue) {
        return new ByteConverter(defaultValue);
    }

    public void setUp() throws Exception {
        this.converter = this.makeConverter();
        this.numbers[0] = Byte.valueOf("-12");
        this.numbers[1] = Byte.valueOf("13");
        this.numbers[2] = Byte.valueOf("-22");
        this.numbers[3] = Byte.valueOf("23");
    }

    public void tearDown() throws Exception {
        this.converter = null;
    }

    public void testInvalidAmount() {
        NumberConverter converter = this.makeConverter();
        Class<Byte> clazz = Byte.class;
        Long min = -128L;
        Long max = 127L;
        Long minMinusOne = min - 1L;
        Long maxPlusOne = max + 1L;
        ByteConverterTestCase.assertEquals((String)"Minimum", (Object)-128, (Object)converter.convert(clazz, (Object)min));
        ByteConverterTestCase.assertEquals((String)"Maximum", (Object)127, (Object)converter.convert(clazz, (Object)max));
        try {
            ByteConverterTestCase.assertEquals((String)"Minimum - 1", null, (Object)converter.convert(clazz, (Object)minMinusOne));
            ByteConverterTestCase.fail((String)"Less than minimum, expected ConversionException");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ByteConverterTestCase.assertEquals((String)"Maximum + 1", null, (Object)converter.convert(clazz, (Object)maxPlusOne));
            ByteConverterTestCase.fail((String)"More than maximum, expected ConversionException");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testSimpleConversion() throws Exception {
        String[] message = new String[]{"from String", "from String", "from String", "from String", "from String", "from String", "from String", "from Byte", "from Short", "from Integer", "from Long", "from Float", "from Double"};
        Object[] input = new Object[]{String.valueOf(-128), "-17", "-1", "0", "1", "17", String.valueOf(127), (byte)7, (short)8, 9, 10L, Float.valueOf(11.1f), 12.2};
        Byte[] expected = new Byte[]{(byte)-128, (byte)-17, (byte)-1, (byte)0, (byte)1, (byte)17, (byte)127, (byte)7, (byte)8, (byte)9, (byte)10, (byte)11, (byte)12};
        for (int i = 0; i < expected.length; ++i) {
            ByteConverterTestCase.assertEquals((String)(message[i] + " to Byte"), (Object)expected[i], (Object)this.converter.convert(Byte.class, input[i]));
            ByteConverterTestCase.assertEquals((String)(message[i] + " to byte"), (Object)expected[i], (Object)this.converter.convert(Byte.TYPE, input[i]));
            ByteConverterTestCase.assertEquals((String)(message[i] + " to null type"), (Object)expected[i], (Object)this.converter.convert(null, input[i]));
        }
    }
}

