/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.CopyOnWriteIndexPart;
import org.apache.uima.cas.impl.FsIndex_iicp;
import org.apache.uima.cas.impl.FsIndex_singletype;
import org.apache.uima.cas.impl.FsIterator_subtypes_snapshot;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.jcas.cas.TOP;

public class FsIndex_flat<T extends FeatureStructure>
extends FsIndex_singletype<T> {
    private final TOP[] indexedFSs;
    private final FsIndex_iicp<T> iicp;
    private final Comparator<TOP> comparatorWithoutId;
    private final int maxAnnotSpan;

    FsIndex_flat(FsIndex_iicp<T> iicp) {
        super(iicp.getCasImpl(), iicp.fsIndex_singletype.getType(), iicp.fsIndex_singletype.getIndexingStrategy(), iicp.fsIndex_singletype.getComparatorImplForIndexSpecs());
        this.iicp = iicp;
        this.indexedFSs = this.fillFlatArray();
        this.comparatorWithoutId = iicp.fsIndex_singletype.comparatorWithoutID;
        this.maxAnnotSpan = iicp.ll_maxAnnotSpan();
    }

    private TOP[] fillFlatArray() {
        TOP[] a = (TOP[])Array.newInstance(TOP.class, this.iicp.size());
        Iterator it = this.iicp.iterator();
        int i = 0;
        while (it.hasNext()) {
            a[i++] = (TOP)it.nextNvc();
        }
        if (i != a.length) {
            throw new ConcurrentModificationException();
        }
        return a;
    }

    FeatureStructure[] getFlatArray() {
        return this.indexedFSs;
    }

    @Override
    public LowLevelIterator<T> iterator() {
        return this.iterator(false, false);
    }

    @Override
    public LowLevelIterator<T> iterator(boolean orderNotNeeded, boolean ignoreType) {
        FsIndex_singletype<T> idx = this.iicp.getFsIndex_singleType();
        Comparator<TOP> comp = orderNotNeeded ? null : (ignoreType ? idx.comparatorNoTypeWithoutID : idx.comparatorWithoutID);
        return new FsIterator_subtypes_snapshot(this, comp);
    }

    @Override
    void insert(T fs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(FeatureStructure fs) {
        return this.find(fs) != null;
    }

    @Override
    public T find(FeatureStructure fs) {
        if (this.isSorted()) {
            for (TOP item : this.indexedFSs) {
                if (this.comparatorWithoutId.compare(item, (TOP)fs) != 0) continue;
                return (T)item;
            }
            return null;
        }
        int r = Arrays.binarySearch(this.indexedFSs, (TOP)fs, this.comparatorWithoutId);
        return (T)(r >= 0 ? this.indexedFSs[r] : null);
    }

    @Override
    public int size() {
        return this.indexedFSs.length;
    }

    @Override
    public boolean deleteFS(T fs) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void bulkAddTo(List<T> v) {
        v.addAll(Arrays.asList(this.indexedFSs));
    }

    protected void bulkAddTo(IntVector v) {
        Arrays.stream(this.indexedFSs).mapToInt(FeatureStructure::_id).forEach(v::add);
    }

    @Override
    public int compare(FeatureStructure fs1, FeatureStructure fs2) {
        return this.comparatorWithoutId.compare((TOP)fs1, (TOP)fs2);
    }

    @Override
    protected CopyOnWriteIndexPart createCopyOnWriteIndexPart() {
        Misc.internalError();
        return null;
    }

    @Override
    public int ll_maxAnnotSpan() {
        return this.maxAnnotSpan;
    }
}

