/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.rapier;

import java.util.ArrayList;
import java.util.Map;
import org.apache.uima.ruta.textruler.TextRulerPlugin;
import org.apache.uima.ruta.textruler.extension.TextRulerController;
import org.apache.uima.ruta.textruler.extension.TextRulerLearnerController;
import org.apache.uima.ruta.textruler.extension.TextRulerLearnerFactory;
import org.apache.uima.ruta.textruler.extension.TextRulerLearnerParameter;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class RapierPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static String ID = "org.apache.uima.ruta.textruler.preference.rapier";
    private TextRulerLearnerController algorithmController;
    private IPreferenceStore store;
    private ArrayList<FieldEditor> fields = new ArrayList();

    public RapierPreferencePage() {
        super(1);
        TextRulerLearnerController ctrl;
        this.algorithmController = ctrl = TextRulerController.getControllerForID("org.apache.uima.ruta.textruler.rapier");
        this.store = TextRulerPlugin.getDefault().getPreferenceStore();
        this.setPreferenceStore(this.store);
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        TextRulerLearnerFactory f = this.algorithmController.getFactory();
        TextRulerLearnerParameter[] params = f.getAlgorithmParameters();
        Map<String, Object> values = f.getAlgorithmParameterStandardValues();
        if (params != null) {
            block4: for (int i = 0; i < params.length; ++i) {
                TextRulerLearnerParameter p = params[i];
                String id = this.algorithmController.getID() + "." + p.id;
                BooleanFieldEditor l = null;
                switch (p.type) {
                    case ML_BOOL_PARAM: {
                        l = new BooleanFieldEditor(id, p.name, this.getFieldEditorParent());
                        this.fields.add((FieldEditor)l);
                        this.addField((FieldEditor)l);
                        this.store.setDefault(id, ((Boolean)values.get(p.id)).booleanValue());
                        l.setPreferenceStore(this.store);
                        continue block4;
                    }
                    case ML_FLOAT_PARAM: 
                    case ML_INT_PARAM: 
                    case ML_DOUBLE_PARAM: 
                    case ML_STRING_PARAM: {
                        l = new StringFieldEditor(id, p.name, this.getFieldEditorParent());
                        this.fields.add((FieldEditor)l);
                        this.addField((FieldEditor)l);
                        this.store.setDefault(id, values.get(p.id).toString());
                        l.setPreferenceStore(this.store);
                        continue block4;
                    }
                }
            }
        }
    }

    protected void performDefaults() {
        for (FieldEditor f : this.fields) {
            f.loadDefault();
        }
    }

    public boolean performOk() {
        for (FieldEditor f : this.fields) {
            f.store();
        }
        return true;
    }
}

