/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.metadata;

import jakarta.validation.ConstraintValidator;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.bval.jsr.metadata.AnnotationBehavior;
import org.apache.bval.jsr.metadata.ClassLoadingValidatorMappingProvider;
import org.apache.bval.jsr.metadata.ValidatorMapping;
import org.apache.bval.jsr.xml.ValidatedByType;
import org.apache.bval.util.Validate;

public class XmlValidationMappingProvider
extends ClassLoadingValidatorMappingProvider {
    private static final Logger log = Logger.getLogger(XmlValidationMappingProvider.class.getName());
    private final Map<Class<? extends Annotation>, ValidatedByType> config;
    private final Function<String, String> classNameTransformer;

    public XmlValidationMappingProvider(Map<Class<? extends Annotation>, ValidatedByType> validatorMappings, Function<String, String> classNameTransformer) {
        this.config = Validate.notNull(validatorMappings, "validatorMappings", new Object[0]);
        this.classNameTransformer = Validate.notNull(classNameTransformer, "classNameTransformer", new Object[0]);
    }

    @Override
    public <A extends Annotation> ValidatorMapping<A> doGetValidatorMapping(Class<A> constraintType) {
        ValidatedByType validatedByType = this.config.get(constraintType);
        if (validatedByType == null) {
            return null;
        }
        return new ValidatorMapping("XML descriptor", this.load(validatedByType.getValue().stream().map(String::trim).map(this.classNameTransformer), ConstraintValidator.class, e -> log.log(Level.SEVERE, "exception loading XML-declared constraint validators", (Throwable)e)).collect(Collectors.toList()), this.toAnnotationBehavior(validatedByType));
    }

    private AnnotationBehavior toAnnotationBehavior(ValidatedByType validatedByType) {
        Boolean includeExistingValidators = validatedByType.getIncludeExistingValidators();
        return includeExistingValidators == null ? AnnotationBehavior.ABSTAIN : (includeExistingValidators != false ? AnnotationBehavior.INCLUDE : AnnotationBehavior.EXCLUDE);
    }
}

