/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.system;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sis.system.SystemListener;
import org.apache.sis.util.Static;
import org.apache.sis.util.logging.Logging;

public final class Loggers
extends Static {
    public static final String ROOT = "org.apache.sis";
    public static final String SYSTEM = "org.apache.sis.system";
    public static final String MATH = "org.apache.sis.math";
    public static final String MEASURE = "org.apache.sis.measure";
    public static final String SQL = "org.apache.sis.sql";
    public static final String XML = "org.apache.sis.xml";
    public static final String WKT = "org.apache.sis.io.wkt";
    public static final String FILTER = "org.apache.sis.filter";
    public static final String GEOMETRY = "org.apache.sis.geometry";
    public static final String ISO_19115 = "org.apache.sis.metadata.iso";
    public static final String CRS_FACTORY = "org.apache.sis.referencing.factory";
    public static final String COORDINATE_OPERATION = "org.apache.sis.referencing.operation";
    public static final String PARAMETER = "org.apache.sis.parameter";
    public static final String LOCALIZATION = "org.apache.sis.util.resources";
    public static final String APPLICATION = "org.apache.sis.application";

    private Loggers() {
    }

    public static SortedMap<String, Level> getEffectiveLevels() {
        TreeMap<String, Level> levels = new TreeMap<String, Level>();
        for (Field field : Loggers.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || field.getType() != String.class) continue;
            try {
                levels.put((String)field.get(null), null);
            }
            catch (IllegalAccessException e) {
                Logging.unexpectedException(SystemListener.LOGGER, Loggers.class, "getEffectiveLevels", e);
            }
        }
        Iterator it = levels.entrySet().iterator();
        block3: while (it.hasNext()) {
            Map.Entry entry = it.next();
            String name = (String)entry.getKey();
            Logger logger = Logger.getLogger(name);
            Level level = Loggers.getEffectiveLevel(logger);
            Level h = Loggers.getHandlerLevel(logger);
            if (h.intValue() > level.intValue()) {
                level = h;
            }
            entry.setValue(level);
            Logger parent = logger;
            while ((parent = parent.getParent()) != null) {
                Level p = (Level)levels.get(parent.getName());
                if (p == null) continue;
                if (!p.equals(level)) continue block3;
                it.remove();
                continue block3;
            }
        }
        return levels;
    }

    private static Level getEffectiveLevel(Logger logger) {
        while (logger != null) {
            Level level = logger.getLevel();
            if (level != null) {
                return level;
            }
            logger = logger.getParent();
        }
        return Level.INFO;
    }

    private static Level getHandlerLevel(Logger logger) {
        Level level = Level.OFF;
        while (logger != null) {
            for (Handler handler : logger.getHandlers()) {
                Level c = handler.getLevel();
                if (c == null || c.intValue() >= level.intValue()) continue;
                level = c;
            }
            if (!logger.getUseParentHandlers()) break;
            logger = logger.getParent();
        }
        return level;
    }
}

