/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.internal;

import java.util.Arrays;
import org.apache.sis.coverage.internal.CompoundTransformOf1D;
import org.apache.sis.coverage.internal.RepeatedTransform;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.FactoryException;

public abstract class CompoundTransform
extends AbstractMathTransform {
    private transient MathTransform inverse;

    CompoundTransform() {
    }

    abstract MathTransform[] components();

    public static MathTransform create(MathTransform[] components) {
        ArgumentChecks.ensureNonNull("components", components);
        int n = components.length;
        if (n == 0) {
            return MathTransforms.identity(0);
        }
        MathTransform first = components[0];
        ArgumentChecks.ensureNonNullElement("components", 0, first);
        if (n == 1) {
            return first;
        }
        if (ArraysExt.allEquals(components, first)) {
            return new RepeatedTransform(first, n);
        }
        MathTransform1D[] as1D = new MathTransform1D[n];
        for (int i = 0; i < n; ++i) {
            MathTransform c = components[i];
            ArgumentChecks.ensureNonNullElement("components", i, c);
            if (!(c instanceof MathTransform1D)) {
                throw new UnsupportedOperationException("Non 1D-case not yet implemented.");
            }
            as1D[i] = (MathTransform1D)c;
        }
        return new CompoundTransformOf1D(as1D);
    }

    @Override
    public int getSourceDimensions() {
        int dim = 0;
        for (MathTransform c : this.components()) {
            dim += c.getSourceDimensions();
        }
        return dim;
    }

    @Override
    public int getTargetDimensions() {
        int dim = 0;
        for (MathTransform c : this.components()) {
            dim += c.getTargetDimensions();
        }
        return dim;
    }

    @Override
    public boolean isIdentity() {
        for (MathTransform c : this.components()) {
            if (c.isIdentity()) continue;
            return false;
        }
        return true;
    }

    @Override
    public final synchronized MathTransform inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            MathTransform[] components = this.components();
            MathTransform[] inverses = new MathTransform1D[components.length];
            for (int i = 0; i < components.length; ++i) {
                inverses[i] = components[i].inverse();
            }
            this.inverse = CompoundTransform.create(inverses);
        }
        return this.inverse;
    }

    @Override
    protected final MathTransform tryConcatenate(boolean applyOtherFirst, MathTransform other, MathTransformFactory factory) throws FactoryException {
        block5: {
            if (other instanceof CompoundTransform) {
                int n;
                MathTransform[] components = this.components();
                MathTransform[] toConcatenate = ((CompoundTransform)other).components();
                if (toConcatenate.length == (n = components.length)) {
                    MathTransform[] concatenated = new MathTransform1D[n];
                    for (int i = 0; i < n; ++i) {
                        MathTransform c1 = components[i];
                        MathTransform c2 = toConcatenate[i];
                        if (applyOtherFirst) {
                            c1 = c2;
                            c2 = components[i];
                        }
                        if (c1.getTargetDimensions() == c2.getSourceDimensions()) {
                            concatenated[i] = factory.createConcatenatedTransform(c1, c2);
                            continue;
                        }
                        break block5;
                    }
                    return CompoundTransform.create(concatenated);
                }
            }
        }
        return super.tryConcatenate(applyOtherFirst, other, factory);
    }

    @Override
    protected final int computeHashCode() {
        return super.hashCode() + Arrays.hashCode(this.components());
    }

    @Override
    public final boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        return super.equals(object, mode) && Utilities.deepEquals(this.components(), ((CompoundTransform)object).components(), mode);
    }
}

