/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeBodyPart;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.mail.smime.SMIMEUtil;
import org.bouncycastle.mail.smime.util.CRLFOutputStream;

public class CMSProcessableBodyPartOutbound
implements CMSProcessable {
    private BodyPart bodyPart;
    private String defaultContentTransferEncoding;

    public CMSProcessableBodyPartOutbound(BodyPart bodyPart) {
        this.bodyPart = bodyPart;
    }

    public CMSProcessableBodyPartOutbound(BodyPart bodyPart, String string) {
        this.bodyPart = bodyPart;
        this.defaultContentTransferEncoding = string;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException, CMSException {
        try {
            if (SMIMEUtil.isCanonicalisationRequired((MimeBodyPart)this.bodyPart, this.defaultContentTransferEncoding)) {
                outputStream = new CRLFOutputStream(outputStream);
            }
            this.bodyPart.writeTo(outputStream);
        }
        catch (MessagingException messagingException) {
            throw new CMSException("can't write BodyPart to stream.", (Exception)((Object)messagingException));
        }
    }

    @Override
    public Object getContent() {
        return this.bodyPart;
    }
}

