/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.CallActivity;
import org.flowable.bpmn.model.ErrorEventDefinition;
import org.flowable.bpmn.model.Event;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.EventSubProcess;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.MapExceptionEntry;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.util.CollectionUtil;
import org.flowable.common.engine.impl.util.ReflectUtil;
import org.flowable.engine.delegate.BpmnError;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.IOParameterUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorPropagation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorPropagation.class);

    public static void propagateError(BpmnError error, DelegateExecution execution) {
        ErrorPropagation.propagateError(new BpmnErrorVariableContainer(error, execution.getTenantId()), execution);
    }

    public static void propagateError(String errorCode, DelegateExecution execution) {
        ErrorPropagation.propagateError(new BpmnErrorVariableContainer(errorCode, execution.getTenantId()), execution);
    }

    protected static void propagateError(String errorCode, Throwable exception, DelegateExecution execution) {
        ErrorPropagation.propagateError(new BpmnErrorVariableContainer(errorCode, exception, execution.getTenantId()), execution);
    }

    protected static void propagateError(BpmnErrorVariableContainer errorVariableContainer, DelegateExecution execution) {
        HashMap<String, List<Event>> eventMap = new HashMap<String, List<Event>>();
        HashSet<String> rootProcessDefinitionIds = new HashSet<String>();
        String errorCode = errorVariableContainer.getErrorCode();
        if (!execution.getProcessInstanceId().equals(execution.getRootProcessInstanceId())) {
            Object parentExecution = (ExecutionEntity)execution;
            while (parentExecution.getParentId() != null || parentExecution.getSuperExecutionId() != null) {
                if (parentExecution.getParentId() != null) {
                    parentExecution = parentExecution.getParent();
                    continue;
                }
                parentExecution = parentExecution.getSuperExecution();
                rootProcessDefinitionIds.add(parentExecution.getProcessDefinitionId());
            }
        }
        if (rootProcessDefinitionIds.size() > 0) {
            for (String processDefinitionId : rootProcessDefinitionIds) {
                eventMap.putAll(ErrorPropagation.findCatchingEventsForProcess(processDefinitionId, errorCode));
            }
        }
        eventMap.putAll(ErrorPropagation.findCatchingEventsForProcess(execution.getProcessDefinitionId(), errorCode));
        if (eventMap.size() > 0) {
            ErrorPropagation.executeCatch(eventMap, execution, errorVariableContainer);
        }
        if (eventMap.size() == 0) {
            BpmnError bpmnError = new BpmnError(errorCode, "No catching boundary event found for error with errorCode '" + errorCode + "', neither in same process nor in parent process");
            bpmnError.setAdditionalDataContainer(errorVariableContainer);
            throw bpmnError;
        }
    }

    protected static void executeCatch(Map<String, List<Event>> eventMap, DelegateExecution delegateExecution, BpmnErrorVariableContainer errorVariableContainer) {
        HashSet<String> toDeleteProcessInstanceIds = new HashSet<String>();
        String errorId = errorVariableContainer.getErrorCode();
        LOGGER.debug("Executing error catch for error={}, execution={}, eventMap={}", new Object[]{errorId, delegateExecution, eventMap});
        Event matchingEvent = null;
        ExecutionEntity currentExecution = (ExecutionEntity)delegateExecution;
        ExecutionEntity parentExecution = null;
        if (delegateExecution.getCurrentFlowableListener() == null && eventMap.containsKey(currentExecution.getActivityId() + "#" + currentExecution.getProcessDefinitionId())) {
            parentExecution = currentExecution.getParentId() != null && currentExecution.getParent().isMultiInstanceRoot() ? currentExecution.getParent() : currentExecution;
            matchingEvent = ErrorPropagation.getCatchEventFromList(eventMap.get(currentExecution.getActivityId() + "#" + currentExecution.getProcessDefinitionId()), parentExecution);
        } else {
            parentExecution = currentExecution.getParent();
            while (matchingEvent == null && parentExecution != null) {
                FlowElementsContainer currentContainer = null;
                if (parentExecution.getCurrentFlowElement() instanceof FlowElementsContainer) {
                    currentContainer = (FlowElementsContainer)parentExecution.getCurrentFlowElement();
                } else if (parentExecution.getId().equals(parentExecution.getProcessInstanceId())) {
                    currentContainer = ProcessDefinitionUtil.getProcess(parentExecution.getProcessDefinitionId());
                }
                if (currentContainer != null) {
                    for (String refId : eventMap.keySet()) {
                        String errorCode;
                        List<Event> events = eventMap.get(refId);
                        if (!CollectionUtil.isNotEmpty(events) || !(events.get(0) instanceof StartEvent)) continue;
                        String refActivityId = refId.substring(0, refId.indexOf(35));
                        String refProcessDefinitionId = refId.substring(refId.indexOf(35) + 1);
                        if (!parentExecution.getProcessDefinitionId().equals(refProcessDefinitionId) || currentContainer.getFlowElement(refActivityId) == null || !StringUtils.isNotEmpty((CharSequence)(errorCode = ErrorPropagation.getErrorCodeFromErrorEventDefinition(matchingEvent = ErrorPropagation.getCatchEventFromList(events, parentExecution))))) continue;
                        break;
                    }
                }
                if (matchingEvent != null) continue;
                if (eventMap.containsKey(parentExecution.getActivityId() + "#" + parentExecution.getProcessDefinitionId())) {
                    if (parentExecution.getParentId() != null && parentExecution.getParent().isMultiInstanceRoot()) {
                        parentExecution = parentExecution.getParent();
                    }
                    matchingEvent = ErrorPropagation.getCatchEventFromList(eventMap.get(parentExecution.getActivityId() + "#" + parentExecution.getProcessDefinitionId()), parentExecution);
                    continue;
                }
                if (StringUtils.isNotEmpty((CharSequence)parentExecution.getParentId())) {
                    parentExecution = parentExecution.getParent();
                    continue;
                }
                if (!parentExecution.getProcessInstanceId().equals(parentExecution.getRootProcessInstanceId())) {
                    toDeleteProcessInstanceIds.add(parentExecution.getProcessInstanceId());
                    parentExecution = parentExecution.getSuperExecution();
                    continue;
                }
                parentExecution = null;
            }
        }
        if (matchingEvent != null && parentExecution != null) {
            for (String processInstanceId : toDeleteProcessInstanceIds) {
                ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager();
                ExecutionEntity processInstanceEntity = (ExecutionEntity)executionEntityManager.findById(processInstanceId);
                executionEntityManager.deleteProcessInstanceExecutionEntity(processInstanceEntity.getId(), currentExecution.getCurrentFlowElement() != null ? currentExecution.getCurrentFlowElement().getId() : null, "ERROR_EVENT " + errorId, false, false, false);
                ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
                FlowableEventDispatcher eventDispatcher = null;
                if (processEngineConfiguration != null) {
                    eventDispatcher = processEngineConfiguration.getEventDispatcher();
                }
                if (eventDispatcher == null || !eventDispatcher.isEnabled()) continue;
                processEngineConfiguration.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.PROCESS_COMPLETED_WITH_ERROR_END_EVENT, processInstanceEntity), processEngineConfiguration.getEngineCfgKey());
            }
        } else {
            throw new FlowableException("No matching parent execution for error code " + errorId + " found");
        }
        ErrorPropagation.executeEventHandler(matchingEvent, parentExecution, currentExecution, errorVariableContainer);
    }

    protected static void executeEventHandler(Event event, ExecutionEntity parentExecution, ExecutionEntity currentExecution, BpmnErrorVariableContainer errorVariableContainer) {
        String modelError;
        String errorId;
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        FlowableEventDispatcher eventDispatcher = null;
        String errorCode = errorId = errorVariableContainer.getErrorCode();
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(parentExecution.getProcessDefinitionId());
        if (bpmnModel != null && (modelError = (String)bpmnModel.getErrors().get(errorId)) != null) {
            errorCode = modelError;
            errorVariableContainer.setErrorCode(errorCode);
        }
        if (processEngineConfiguration != null) {
            eventDispatcher = processEngineConfiguration.getEventDispatcher();
        }
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            processEngineConfiguration.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createErrorEvent(FlowableEngineEventType.ACTIVITY_ERROR_RECEIVED, event.getId(), errorId, errorCode, parentExecution.getId(), parentExecution.getProcessInstanceId(), parentExecution.getProcessDefinitionId()), processEngineConfiguration.getEngineCfgKey());
        }
        if (event instanceof StartEvent) {
            ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager();
            if (parentExecution.isProcessInstanceType()) {
                LOGGER.debug("Ending and deleting child executions for parent execution '{}'. Reason: Parent Execution is processIntanceType. Current Execution '{}'", (Object)parentExecution, (Object)currentExecution);
                executionEntityManager.deleteChildExecutions(parentExecution, null, true);
            } else if (!currentExecution.getParentId().equals(parentExecution.getId())) {
                LOGGER.debug("Planing destroyScopeOperation for execution {}. Reason: {}. Parent execution: {}", new Object[]{currentExecution, "Current execution parentId odes not match parentExecution id", parentExecution});
                CommandContextUtil.getAgenda().planDestroyScopeOperation(currentExecution);
            } else {
                LOGGER.debug("Deleting execution and related data for execution {}.", (Object)currentExecution);
                executionEntityManager.deleteExecutionAndRelatedData(currentExecution, null, false);
            }
            ExecutionEntity eventSubProcessExecution = executionEntityManager.createChildExecution(parentExecution);
            ErrorPropagation.injectErrorContext(event, eventSubProcessExecution, errorVariableContainer, processEngineConfiguration.getExpressionManager());
            if (event.getSubProcess() != null) {
                eventSubProcessExecution.setCurrentFlowElement((FlowElement)event.getSubProcess());
                CommandContextUtil.getActivityInstanceEntityManager().recordActivityStart(eventSubProcessExecution);
                ExecutionEntity subProcessStartEventExecution = executionEntityManager.createChildExecution(eventSubProcessExecution);
                subProcessStartEventExecution.setCurrentFlowElement((FlowElement)event);
                LOGGER.debug("Error StartEvent SubProcess handler {}{} for errorCode {} continueProcessOperation with execution {}", new Object[]{event, event.getSubProcess(), errorCode, subProcessStartEventExecution});
                CommandContextUtil.getAgenda().planContinueProcessOperation(subProcessStartEventExecution);
            } else {
                LOGGER.debug("Error StartEvent handler {} for errorCode {} continueProcessOperation with execution {}", new Object[]{event, errorCode, eventSubProcessExecution});
                eventSubProcessExecution.setCurrentFlowElement((FlowElement)event);
                CommandContextUtil.getAgenda().planContinueProcessOperation(eventSubProcessExecution);
            }
        } else {
            ExecutionEntity boundaryExecution = null;
            List<? extends ExecutionEntity> childExecutions = parentExecution.getExecutions();
            for (ExecutionEntity executionEntity : childExecutions) {
                if (executionEntity == null || executionEntity.getActivityId() == null || !executionEntity.getActivityId().equals(event.getId())) continue;
                boundaryExecution = executionEntity;
            }
            ErrorPropagation.injectErrorContext(event, boundaryExecution, errorVariableContainer, processEngineConfiguration.getExpressionManager());
            CommandContextUtil.getAgenda().planTriggerExecutionOperation(boundaryExecution);
        }
    }

    protected static Map<String, List<Event>> findCatchingEventsForProcess(String processDefinitionId, String errorCode) {
        HashMap<String, List<Event>> eventMap = new HashMap<String, List<Event>>();
        Process process = ProcessDefinitionUtil.getProcess(processDefinitionId);
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinitionId);
        String compareErrorCode = ErrorPropagation.retrieveErrorCode(bpmnModel, errorCode);
        List subProcesses = process.findFlowElementsOfType(EventSubProcess.class, true);
        for (EventSubProcess eventSubProcess : subProcesses) {
            for (FlowElement flowElement : eventSubProcess.getFlowElements()) {
                ErrorEventDefinition errorEventDef;
                String eventErrorCode;
                StartEvent startEvent;
                if (!(flowElement instanceof StartEvent) || !CollectionUtil.isNotEmpty((Collection)(startEvent = (StartEvent)flowElement).getEventDefinitions()) || !(startEvent.getEventDefinitions().get(0) instanceof ErrorEventDefinition) || (eventErrorCode = ErrorPropagation.retrieveErrorCode(bpmnModel, (errorEventDef = (ErrorEventDefinition)startEvent.getEventDefinitions().get(0)).getErrorCode())) != null && compareErrorCode != null && !eventErrorCode.equals(compareErrorCode)) continue;
                ArrayList<StartEvent> startEvents = new ArrayList<StartEvent>();
                startEvents.add(startEvent);
                eventMap.put(eventSubProcess.getId() + "#" + processDefinitionId, startEvents);
            }
        }
        List boundaryEvents = process.findFlowElementsOfType(BoundaryEvent.class, true);
        for (BoundaryEvent boundaryEvent : boundaryEvents) {
            ErrorEventDefinition errorEventDef;
            String eventErrorCode;
            if (boundaryEvent.getAttachedToRefId() == null || !CollectionUtil.isNotEmpty((Collection)boundaryEvent.getEventDefinitions()) || !(boundaryEvent.getEventDefinitions().get(0) instanceof ErrorEventDefinition) || boundaryEvent.getAttachedToRef() instanceof EventSubProcess || (eventErrorCode = ErrorPropagation.retrieveErrorCode(bpmnModel, (errorEventDef = (ErrorEventDefinition)boundaryEvent.getEventDefinitions().get(0)).getErrorCode())) != null && compareErrorCode != null && !eventErrorCode.equals(compareErrorCode)) continue;
            List<BoundaryEvent> elementBoundaryEvents = null;
            if (!eventMap.containsKey(boundaryEvent.getAttachedToRefId() + "#" + processDefinitionId)) {
                elementBoundaryEvents = new ArrayList();
                eventMap.put(boundaryEvent.getAttachedToRefId() + "#" + processDefinitionId, elementBoundaryEvents);
            } else {
                elementBoundaryEvents = (List)eventMap.get(boundaryEvent.getAttachedToRefId() + "#" + processDefinitionId);
            }
            elementBoundaryEvents.add(boundaryEvent);
        }
        return eventMap;
    }

    public static boolean mapException(Exception e, ExecutionEntity execution, List<MapExceptionEntry> exceptionMap) {
        CallActivity callActivity;
        String errorCode = ErrorPropagation.findMatchingExceptionMapping(e, exceptionMap);
        if (errorCode != null) {
            ErrorPropagation.propagateError(errorCode, e, execution);
            return true;
        }
        DelegateExecution callActivityExecution = null;
        ExecutionEntity parentExecution = execution.getParent();
        while (parentExecution != null && callActivityExecution == null) {
            if (parentExecution.getId().equals(parentExecution.getProcessInstanceId())) {
                if (parentExecution.getSuperExecution() != null) {
                    callActivityExecution = parentExecution.getSuperExecution();
                    continue;
                }
                parentExecution = null;
                continue;
            }
            parentExecution = parentExecution.getParent();
        }
        if (callActivityExecution != null && CollectionUtil.isNotEmpty((Collection)(callActivity = (CallActivity)callActivityExecution.getCurrentFlowElement()).getMapExceptions()) && (errorCode = ErrorPropagation.findMatchingExceptionMapping(e, callActivity.getMapExceptions())) != null) {
            ErrorPropagation.propagateError(errorCode, e, callActivityExecution);
            return true;
        }
        return false;
    }

    public static String findMatchingExceptionMapping(Exception e, List<MapExceptionEntry> exceptionMap) {
        String defaultExceptionMapping = null;
        for (MapExceptionEntry me : exceptionMap) {
            Class exceptionClassClass;
            String exceptionClass = me.getClassName();
            String errorCode = me.getErrorCode();
            String rootCause = me.getRootCause();
            if (StringUtils.isNotEmpty((CharSequence)errorCode) && StringUtils.isEmpty((CharSequence)exceptionClass) && defaultExceptionMapping == null) {
                if (StringUtils.isNotEmpty((CharSequence)rootCause)) {
                    if (ExceptionUtils.getRootCause((Throwable)e).getClass().getName().equals(rootCause)) {
                        defaultExceptionMapping = errorCode;
                        continue;
                    }
                } else {
                    defaultExceptionMapping = errorCode;
                    continue;
                }
            }
            if (StringUtils.isEmpty((CharSequence)errorCode) || StringUtils.isEmpty((CharSequence)exceptionClass)) continue;
            if (e.getClass().getName().equals(exceptionClass)) {
                if (StringUtils.isNotEmpty((CharSequence)rootCause)) {
                    if (!ExceptionUtils.getRootCause((Throwable)e).getClass().getName().equals(rootCause)) continue;
                    return errorCode;
                }
                return errorCode;
            }
            if (!me.isAndChildren() || !(exceptionClassClass = ReflectUtil.loadClass((String)exceptionClass)).isAssignableFrom(e.getClass())) continue;
            if (StringUtils.isNotEmpty((CharSequence)rootCause)) {
                if (!ExceptionUtils.getRootCause((Throwable)e).getClass().getName().equals(rootCause)) continue;
                return errorCode;
            }
            return errorCode;
        }
        return defaultExceptionMapping;
    }

    protected static Event getCatchEventFromList(List<Event> events, ExecutionEntity parentExecution) {
        Event selectedEvent = null;
        String selectedEventErrorCode = null;
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(parentExecution.getProcessDefinitionId());
        for (Event event : events) {
            String errorCode = ErrorPropagation.getErrorCodeFromErrorEventDefinition(event);
            if (bpmnModel != null) {
                errorCode = ErrorPropagation.retrieveErrorCode(bpmnModel, errorCode);
            }
            if (selectedEvent != null && (!StringUtils.isEmpty(selectedEventErrorCode) || !StringUtils.isNotEmpty((CharSequence)errorCode))) continue;
            selectedEvent = event;
            selectedEventErrorCode = errorCode;
        }
        return selectedEvent;
    }

    protected static String getErrorCodeFromErrorEventDefinition(Event event) {
        for (EventDefinition eventDefinition : event.getEventDefinitions()) {
            if (!(eventDefinition instanceof ErrorEventDefinition)) continue;
            return ((ErrorEventDefinition)eventDefinition).getErrorCode();
        }
        return null;
    }

    protected static String retrieveErrorCode(BpmnModel bpmnModel, String errorCode) {
        String finalErrorCode = null;
        finalErrorCode = errorCode != null && bpmnModel.containsErrorRef(errorCode) ? (String)bpmnModel.getErrors().get(errorCode) : errorCode;
        return finalErrorCode;
    }

    public static <E extends Throwable> void handleException(Throwable exc, ExecutionEntity execution, List<MapExceptionEntry> exceptionMap) throws E {
        BpmnError error = null;
        for (Throwable cause = exc; cause != null; cause = cause.getCause()) {
            if (cause instanceof BpmnError) {
                error = (BpmnError)((Object)cause);
                break;
            }
            if (!(cause instanceof Exception) || !ErrorPropagation.mapException((Exception)cause, execution, exceptionMap)) continue;
            return;
        }
        if (error == null) {
            throw exc;
        }
        ErrorPropagation.propagateError(error, (DelegateExecution)execution);
    }

    protected static void injectErrorContext(Event event, ExecutionEntity execution, BpmnErrorVariableContainer errorSourceContainer, ExpressionManager expressionManager) {
        for (EventDefinition eventDefinition : event.getEventDefinitions()) {
            if (!(eventDefinition instanceof ErrorEventDefinition)) continue;
            ErrorEventDefinition definition = (ErrorEventDefinition)eventDefinition;
            IOParameterUtil.processInParameters(event.getInParameters(), errorSourceContainer, (VariableContainer)execution, expressionManager);
            String variableName = definition.getErrorVariableName();
            if (variableName == null || variableName.isEmpty()) continue;
            String errorCode = errorSourceContainer.getErrorCode();
            if (definition.getErrorVariableTransient() != null && definition.getErrorVariableTransient().booleanValue()) {
                if (definition.getErrorVariableLocalScope() != null && definition.getErrorVariableLocalScope().booleanValue()) {
                    execution.setTransientVariableLocal(variableName, errorCode);
                    continue;
                }
                execution.setTransientVariable(variableName, errorCode);
                continue;
            }
            if (definition.getErrorVariableLocalScope() != null && definition.getErrorVariableLocalScope().booleanValue()) {
                execution.setVariableLocal(variableName, errorCode);
                continue;
            }
            execution.setVariable(variableName, errorCode);
        }
    }

    protected static class BpmnErrorVariableContainer
    implements VariableContainer {
        private static final String ERROR_CODE_VARIABLE_NAME = "errorCode";
        private static final String ERROR_VARIABLE_NAME = "error";
        private static final String ERROR_MESSAGE_VARIABLE_NAME = "errorMessage";
        protected String errorCode;
        protected Throwable error;
        protected VariableContainer additionalDataContainer;
        protected String tenantId;

        protected BpmnErrorVariableContainer(String errorCode, String tenantId) {
            this.errorCode = errorCode;
            this.tenantId = tenantId;
        }

        protected BpmnErrorVariableContainer(BpmnError error, String tenantId) {
            this.error = error;
            this.additionalDataContainer = error.getAdditionalDataContainer();
            this.errorCode = error.getErrorCode();
            this.tenantId = tenantId;
        }

        protected BpmnErrorVariableContainer(String errorCode, Throwable error, String tenantId) {
            this.error = error;
            if (error instanceof BpmnError) {
                this.additionalDataContainer = ((BpmnError)((Object)error)).getAdditionalDataContainer();
            }
            this.errorCode = errorCode;
            this.tenantId = tenantId;
        }

        protected String getErrorCode() {
            return this.errorCode;
        }

        protected void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public boolean hasVariable(String variableName) {
            if (ERROR_CODE_VARIABLE_NAME.equals(variableName) || ERROR_VARIABLE_NAME.equals(variableName) || ERROR_MESSAGE_VARIABLE_NAME.equals(variableName)) {
                return true;
            }
            if (this.additionalDataContainer != null) {
                return this.additionalDataContainer.hasVariable(variableName);
            }
            return false;
        }

        public Object getVariable(String variableName) {
            if (ERROR_CODE_VARIABLE_NAME.equals(variableName)) {
                return this.errorCode;
            }
            if (ERROR_VARIABLE_NAME.equals(variableName)) {
                return this.error;
            }
            if (ERROR_MESSAGE_VARIABLE_NAME.equals(variableName)) {
                return this.error != null ? this.error.getMessage() : null;
            }
            if (this.additionalDataContainer != null) {
                return this.additionalDataContainer.getVariable(variableName);
            }
            return null;
        }

        public void setVariable(String variableName, Object variableValue) {
            throw new UnsupportedOperationException("Not allowed to set variables in a bpmn error variable container");
        }

        public void setTransientVariable(String variableName, Object variableValue) {
            throw new UnsupportedOperationException("Not allowed to set variables in a bpmn error variable container");
        }

        public String getTenantId() {
            return this.tenantId;
        }
    }
}

