/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.MapExceptionEntry;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableIllegalStateException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.FutureJavaDelegate;
import org.flowable.engine.delegate.JavaDelegate;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.DelegateExpressionUtil;
import org.flowable.engine.impl.bpmn.helper.ErrorPropagation;
import org.flowable.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.flowable.engine.impl.bpmn.parser.FieldDeclaration;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.context.BpmnOverrideContext;
import org.flowable.engine.impl.delegate.ActivityBehavior;
import org.flowable.engine.impl.delegate.ActivityBehaviorInvocation;
import org.flowable.engine.impl.delegate.TriggerableActivityBehavior;
import org.flowable.engine.impl.delegate.invocation.FutureJavaDelegateInvocation;
import org.flowable.engine.impl.delegate.invocation.JavaDelegateInvocation;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.BpmnLoggingSessionUtil;
import org.flowable.engine.impl.util.CommandContextUtil;

public class ServiceTaskDelegateExpressionActivityBehavior
extends TaskActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected String serviceTaskId;
    protected Expression expression;
    protected Expression skipExpression;
    protected List<FieldDeclaration> fieldDeclarations;
    protected List<MapExceptionEntry> mapExceptions;
    protected boolean triggerable;

    public ServiceTaskDelegateExpressionActivityBehavior(String serviceTaskId, Expression expression, Expression skipExpression, List<FieldDeclaration> fieldDeclarations, List<MapExceptionEntry> mapExceptions, boolean triggerable) {
        this.serviceTaskId = serviceTaskId;
        this.expression = expression;
        this.skipExpression = skipExpression;
        this.fieldDeclarations = fieldDeclarations;
        this.mapExceptions = mapExceptions;
        this.triggerable = triggerable;
    }

    @Override
    public void trigger(DelegateExecution execution, String signalName, Object signalData) {
        Object delegate = DelegateExpressionUtil.resolveDelegateExpression(this.expression, (VariableContainer)execution, this.fieldDeclarations);
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        boolean loggingSessionEnabled = processEngineConfiguration.isLoggingSessionEnabled();
        try {
            if (this.triggerable && delegate instanceof TriggerableActivityBehavior) {
                if (loggingSessionEnabled) {
                    BpmnLoggingSessionUtil.addLoggingData("serviceTaskBeforeTrigger", "Triggering service task with delegate " + delegate, execution);
                }
                ((TriggerableActivityBehavior)delegate).trigger(execution, signalName, signalData);
                if (loggingSessionEnabled) {
                    BpmnLoggingSessionUtil.addLoggingData("serviceTaskAfterTrigger", "Triggered service task with delegate " + delegate, execution);
                }
            } else if (loggingSessionEnabled) {
                if (!this.triggerable) {
                    BpmnLoggingSessionUtil.addLoggingData("serviceTaskWrongTrigger", "Service task with delegate expression triggered but not triggerable " + delegate, execution);
                } else {
                    BpmnLoggingSessionUtil.addLoggingData("serviceTaskWrongTrigger", "Service task with delegate expression triggered but not implementing TriggerableActivityBehavior " + delegate, execution);
                }
            }
            this.leave(execution);
        }
        catch (Exception exc) {
            this.handleException(exc, execution, loggingSessionEnabled);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(DelegateExecution execution) {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        boolean loggingSessionEnabled = processEngineConfiguration.isLoggingSessionEnabled();
        try {
            boolean isSkipExpressionEnabled;
            String skipExpressionText = null;
            if (this.skipExpression != null) {
                skipExpressionText = this.skipExpression.getExpressionText();
            }
            if (!(isSkipExpressionEnabled = SkipExpressionUtil.isSkipExpressionEnabled(skipExpressionText, this.serviceTaskId, execution, commandContext)) || !SkipExpressionUtil.shouldSkipFlowElement(skipExpressionText, this.serviceTaskId, execution, commandContext)) {
                String overrideExpression;
                ObjectNode taskElementProperties;
                if (processEngineConfiguration.isEnableProcessDefinitionInfoCache() && (taskElementProperties = BpmnOverrideContext.getBpmnOverrideElementProperties(this.serviceTaskId, execution.getProcessDefinitionId())) != null && taskElementProperties.has("serviceTaskDelegateExpression") && StringUtils.isNotEmpty((CharSequence)(overrideExpression = taskElementProperties.get("serviceTaskDelegateExpression").asText())) && !overrideExpression.equals(this.expression.getExpressionText())) {
                    this.expression = processEngineConfiguration.getExpressionManager().createExpression(overrideExpression);
                }
                Object delegate = DelegateExpressionUtil.resolveDelegateExpression(this.expression, (VariableContainer)execution, this.fieldDeclarations);
                if (loggingSessionEnabled) {
                    BpmnLoggingSessionUtil.addLoggingData("serviceTaskEnter", "Executing service task with delegate " + delegate, execution);
                }
                if (delegate instanceof ActivityBehavior) {
                    if (delegate instanceof AbstractBpmnActivityBehavior) {
                        ((AbstractBpmnActivityBehavior)delegate).setMultiInstanceActivityBehavior(this.getMultiInstanceActivityBehavior());
                    }
                    processEngineConfiguration.getDelegateInterceptor().handleInvocation(new ActivityBehaviorInvocation((ActivityBehavior)delegate, execution));
                    if (!loggingSessionEnabled) return;
                    BpmnLoggingSessionUtil.addLoggingData("serviceTaskExit", "Executed service task with delegate " + delegate, execution);
                    return;
                } else if (delegate instanceof JavaDelegate) {
                    processEngineConfiguration.getDelegateInterceptor().handleInvocation(new JavaDelegateInvocation((JavaDelegate)delegate, execution));
                    if (!this.triggerable) {
                        this.leave(execution);
                    }
                    if (!loggingSessionEnabled) return;
                    BpmnLoggingSessionUtil.addLoggingData("serviceTaskExit", "Executed service task with delegate " + delegate, execution);
                    return;
                } else {
                    if (!(delegate instanceof FutureJavaDelegate)) throw new FlowableIllegalArgumentException("Delegate expression " + this.expression + " did neither resolve to an implementation of " + ActivityBehavior.class + " nor " + JavaDelegate.class);
                    FutureJavaDelegate futureJavaDelegate = (FutureJavaDelegate)delegate;
                    FutureJavaDelegateInvocation invocation = new FutureJavaDelegateInvocation(futureJavaDelegate, execution, processEngineConfiguration.getAsyncTaskInvoker());
                    processEngineConfiguration.getDelegateInterceptor().handleInvocation(invocation);
                    Object invocationResult = invocation.getInvocationResult();
                    if (!(invocationResult instanceof CompletableFuture)) throw new FlowableIllegalStateException("Invocation result " + invocationResult + " from invocation " + invocation + " was not a CompletableFuture");
                    CompletableFuture future = (CompletableFuture)invocationResult;
                    CommandContextUtil.getAgenda(commandContext).planFutureOperation(future, new FutureJavaDelegateCompleteAction(futureJavaDelegate, execution, loggingSessionEnabled));
                }
                return;
            } else {
                if (loggingSessionEnabled) {
                    BpmnLoggingSessionUtil.addLoggingData("skipTask", "Skipped service task " + execution.getCurrentActivityId() + " with skip expression " + skipExpressionText, execution);
                }
                this.leave(execution);
            }
            return;
        }
        catch (Exception exc) {
            this.handleException(exc, execution, loggingSessionEnabled);
        }
    }

    protected void handleException(Throwable exc, DelegateExecution execution, boolean loggingSessionEnabled) {
        if (loggingSessionEnabled) {
            BpmnLoggingSessionUtil.addErrorLoggingData("serviceTaskException", "Service task with delegate expression " + this.expression + " threw exception " + exc.getMessage(), exc, execution);
        }
        ErrorPropagation.handleException(exc, (ExecutionEntity)execution, this.mapExceptions);
    }

    protected class FutureJavaDelegateCompleteAction
    implements BiConsumer<Object, Throwable> {
        protected final FutureJavaDelegate<Object> delegateInstance;
        protected final DelegateExecution execution;
        protected final boolean loggingSessionEnabled;

        public FutureJavaDelegateCompleteAction(FutureJavaDelegate<Object> delegateInstance, DelegateExecution execution, boolean loggingSessionEnabled) {
            this.delegateInstance = delegateInstance;
            this.execution = execution;
            this.loggingSessionEnabled = loggingSessionEnabled;
        }

        @Override
        public void accept(Object value, Throwable throwable) {
            if (throwable == null) {
                try {
                    this.delegateInstance.afterExecution(this.execution, value);
                    if (!ServiceTaskDelegateExpressionActivityBehavior.this.triggerable) {
                        ServiceTaskDelegateExpressionActivityBehavior.this.leave(this.execution);
                    }
                }
                catch (Exception ex) {
                    ServiceTaskDelegateExpressionActivityBehavior.this.handleException(ex, this.execution, this.loggingSessionEnabled);
                }
                if (this.loggingSessionEnabled) {
                    BpmnLoggingSessionUtil.addLoggingData("serviceTaskExit", "Executed service task with delegate " + this.delegateInstance, this.execution);
                }
            } else {
                ServiceTaskDelegateExpressionActivityBehavior.this.handleException(throwable, this.execution, this.loggingSessionEnabled);
            }
        }
    }
}

