/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.openjpa.jdbc.kernel.ConnectionInfo;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCLockManager;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.FieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.ContainerFieldStrategy;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.SQLFactory;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.VersionLockManager;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.LockException;

public class PessimisticLockManager
extends VersionLockManager
implements JDBCLockManager {
    public static final int LOCK_DATASTORE_ONLY = 1;
    private static final Localizer _loc = Localizer.forPackage(PessimisticLockManager.class);
    protected JDBCStore _store;

    public PessimisticLockManager() {
        this.setVersionCheckOnReadLock(false);
        this.setVersionUpdateOnWriteLock(false);
    }

    public void setContext(StoreContext ctx) {
        super.setContext(ctx);
        this._store = (JDBCStore)ctx.getStoreManager().getInnermostDelegate();
    }

    @Override
    public boolean selectForUpdate(Select sel, int lockLevel) {
        if (lockLevel == 0) {
            return false;
        }
        DBDictionary dict = this._store.getDBDictionary();
        if (dict.simulateLocking) {
            return false;
        }
        dict.assertSupport(dict.supportsSelectForUpdate, "SupportsSelectForUpdate");
        if (!sel.supportsLocking()) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)_loc.get("cant-lock-on-load", (Object)sel.toSelect(false, null).getSQL()));
            }
            return false;
        }
        this.ensureStoreManagerTransaction();
        return true;
    }

    @Override
    public void loadedForUpdate(OpenJPAStateManager sm) {
        if (this.getLockLevel(sm) == 0) {
            this.setLockLevel(sm, 1);
        }
    }

    protected void lockInternal(OpenJPAStateManager sm, int level, int timeout, Object sdata, boolean postVersionCheck) {
        ConnectionInfo info = (ConnectionInfo)sdata;
        if (info == null || info.result == null || !info.result.isLocking()) {
            this.lockRow(sm, timeout, level);
        }
        this.optimisticLockInternal(sm, level, timeout, sdata, postVersionCheck);
    }

    private void lockRow(OpenJPAStateManager sm, int timeout, int level) {
        ArrayList<SQLBuffer> sqls;
        DBDictionary dict = this._store.getDBDictionary();
        JDBCFetchConfiguration fetch = this._store.getFetchConfiguration();
        if (dict.simulateLocking) {
            return;
        }
        dict.assertSupport(dict.supportsSelectForUpdate, "SupportsSelectForUpdate");
        Object id = sm.getObjectId();
        ClassMapping mapping = (ClassMapping)sm.getMetaData();
        List<Object> list = sqls = sm.getLock() == null || sm.getLock().equals(0) ? this.getLockRows(dict, id, mapping, fetch, this._store.getSQLFactory()) : new ArrayList();
        if (this.ctx.getFetchConfiguration().getLockScope() == 10) {
            this.lockJoinTables(sqls, dict, id, mapping, fetch, this._store.getSQLFactory());
        }
        this.ensureStoreManagerTransaction();
        Connection conn = this._store.getConnection();
        Statement stmnt = null;
        ResultSet rs = null;
        try {
            for (SQLBuffer sql : sqls) {
                stmnt = this.prepareStatement(conn, sql);
                dict.setTimeouts((PreparedStatement)stmnt, fetch, true);
                rs = this.executeQuery(conn, (PreparedStatement)stmnt, sql);
                this.checkLock(rs, sm, timeout);
            }
        }
        catch (SQLException se) {
            LockException e = new LockException((Object)sm.getPersistenceCapable(), timeout, level);
            e.setCause((Throwable)se);
            e.setFatal(dict.isFatalException(1, se) || level >= 30);
            throw e;
        }
        finally {
            if (stmnt != null) {
                try {
                    stmnt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    protected List<SQLBuffer> getLockRows(DBDictionary dict, Object id, ClassMapping mapping, JDBCFetchConfiguration fetch, SQLFactory factory) {
        while (mapping.getJoinablePCSuperclassMapping() != null) {
            mapping = mapping.getJoinablePCSuperclassMapping();
        }
        Select select = factory.newSelect();
        select.select(mapping.getPrimaryKeyColumns());
        select.wherePrimaryKey(id, mapping, this._store);
        ArrayList<SQLBuffer> sqls = new ArrayList<SQLBuffer>();
        sqls.add(select.toSelect(true, fetch));
        return sqls;
    }

    protected void lockJoinTables(List<SQLBuffer> sqls, DBDictionary dict, Object id, ClassMapping mapping, JDBCFetchConfiguration fetch, SQLFactory factory) {
        FieldMapping[] fms;
        for (FieldMapping fm : fms = mapping.getFieldMappings()) {
            FieldStrategy strat = fm.getStrategy();
            if (!(strat instanceof ContainerFieldStrategy)) continue;
            ForeignKey fk = ((ContainerFieldStrategy)strat).getJoinForeignKey();
            Select select = factory.newSelect();
            select.select(fk.getColumns());
            select.whereForeignKey(fk, id, fm.getDefiningMapping(), this._store);
            sqls.add(select.toSelect(true, fetch));
        }
    }

    private void ensureStoreManagerTransaction() {
        if (!this._store.getContext().isStoreActive()) {
            this._store.getContext().beginStore();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)_loc.get("start-trans-for-lock"));
            }
        }
    }

    public JDBCStore getStore() {
        return this._store;
    }

    protected PreparedStatement prepareStatement(Connection conn, SQLBuffer sql) throws SQLException {
        return sql.prepareStatement(conn);
    }

    protected ResultSet executeQuery(Connection conn, PreparedStatement stmnt, SQLBuffer sql) throws SQLException {
        return stmnt.executeQuery();
    }

    protected void checkLock(ResultSet rs, OpenJPAStateManager sm, int timeout) throws SQLException {
        if (!rs.next()) {
            throw new LockException(sm.getManagedInstance(), timeout);
        }
    }
}

