/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import java.util.Collection;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntityManager;

public class UnlockTimerJobsCmd
implements Command<Void> {
    protected final Collection<TimerJobEntity> timerJobs;
    protected final JobServiceConfiguration jobServiceConfiguration;

    public UnlockTimerJobsCmd(Collection<TimerJobEntity> timerJobs, JobServiceConfiguration jobServiceConfiguration) {
        this.timerJobs = timerJobs;
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public Void execute(CommandContext commandContext) {
        TimerJobEntityManager timerJobEntityManager = this.jobServiceConfiguration.getTimerJobEntityManager();
        for (TimerJobEntity timerJob : this.timerJobs) {
            TimerJobEntity dbTimerJob = (TimerJobEntity)timerJobEntityManager.findById(timerJob.getId());
            if (dbTimerJob == null) continue;
            dbTimerJob.setLockOwner(null);
            dbTimerJob.setLockExpirationTime(null);
        }
        return null;
    }
}

