/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.Optional;
import org.apache.syncope.common.lib.request.AbstractPatchItem;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.PasswordPatch;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.ConnInstance;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.PullActions;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class DBPasswordPullActions
implements PullActions {
    protected static final Logger LOG = LoggerFactory.getLogger(DBPasswordPullActions.class);
    protected static final String CLEARTEXT = "CLEARTEXT";
    @Autowired
    protected UserDAO userDAO;
    protected String encodedPassword;
    protected CipherAlgorithm cipher;

    @Transactional(readOnly=true)
    public void beforeProvision(ProvisioningProfile<?, ?> profile, SyncDelta delta, AnyCR anyCR) throws JobExecutionException {
        if (anyCR instanceof UserCR) {
            String password = ((UserCR)anyCR).getPassword();
            this.parseEncodedPassword(password, profile.getConnector());
        }
    }

    @Transactional(readOnly=true)
    public void beforeUpdate(ProvisioningProfile<?, ?> profile, SyncDelta delta, EntityTO entityTO, AnyUR anyUR) throws JobExecutionException {
        if (anyUR instanceof UserUR) {
            PasswordPatch modPassword = ((UserUR)anyUR).getPassword();
            this.parseEncodedPassword(Optional.ofNullable(modPassword).map(AbstractPatchItem::getValue).orElse(null), profile.getConnector());
        }
    }

    protected void parseEncodedPassword(String password, Connector connector) {
        ConnInstance connInstance;
        String cipherAlgorithm;
        if (password != null && !CLEARTEXT.equals(cipherAlgorithm = this.getCipherAlgorithm(connInstance = connector.getConnInstance()))) {
            try {
                this.encodedPassword = password;
                this.cipher = CipherAlgorithm.valueOf((String)cipherAlgorithm);
            }
            catch (IllegalArgumentException e) {
                LOG.error("Cipher algorithm not allowed: {}", (Object)cipherAlgorithm, (Object)e);
                this.encodedPassword = null;
            }
        }
    }

    protected String getCipherAlgorithm(ConnInstance connInstance) {
        return connInstance.getConf().stream().filter(property -> "cipherAlgorithm".equals(property.getSchema().getName()) && property.getValues() != null && !property.getValues().isEmpty()).findFirst().map(cipherAlgorithm -> cipherAlgorithm.getValues().get(0).toString()).orElse(CLEARTEXT);
    }

    @Transactional
    public void after(ProvisioningProfile<?, ?> profile, SyncDelta delta, EntityTO any, ProvisioningReport result) throws JobExecutionException {
        if (any instanceof UserTO && this.encodedPassword != null && this.cipher != null) {
            User user = (User)this.userDAO.find(any.getKey());
            if (user != null) {
                user.setEncodedPassword(this.encodedPassword.toUpperCase(), this.cipher);
            }
            this.encodedPassword = null;
            this.cipher = null;
        }
    }
}

