/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Objects;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;

public interface ReturnTypeParser {
    public static Type resolveType(Type genericType, @Nullable Class<?> contextClass) {
        if (contextClass != null) {
            if (genericType instanceof TypeVariable) {
                Class resolved;
                ResolvableType resolvedTypeVariable = ReturnTypeParser.resolveVariable((TypeVariable)genericType, ResolvableType.forClass(contextClass));
                if (resolvedTypeVariable != ResolvableType.NONE && (resolved = resolvedTypeVariable.resolve()) != null) {
                    return resolved;
                }
            } else if (genericType instanceof ParameterizedType) {
                ResolvableType resolvedType = ResolvableType.forType((Type)genericType);
                if (resolvedType.hasUnresolvableGenerics()) {
                    ResolvableType resolvableType = ReturnTypeParser.getResolvedType(resolvedType, contextClass);
                    if (resolvableType != null) {
                        return resolvableType.getType();
                    }
                } else if (resolvedType.hasGenerics()) {
                    ResolvableType[] resolvableTypes = resolvedType.getGenerics();
                    ReturnTypeParser.resolveType(resolvableTypes, contextClass);
                    return ResolvableType.forClassWithGenerics((Class)Objects.requireNonNull(resolvedType.getRawClass()), (ResolvableType[])resolvableTypes).getType();
                }
            }
        }
        return genericType;
    }

    public static void resolveType(ResolvableType[] resolvableTypes, Class<?> contextClass) {
        for (int i = 0; i < resolvableTypes.length; ++i) {
            if (resolvableTypes[i].hasUnresolvableGenerics() && resolvableTypes[i].getType() instanceof ParameterizedType) {
                ResolvableType resolvableType = ReturnTypeParser.getResolvedType(resolvableTypes[i], contextClass);
                if (resolvableType == null) continue;
                resolvableTypes[i] = resolvableType;
                continue;
            }
            if (!resolvableTypes[i].hasGenerics()) continue;
            ReturnTypeParser.resolveType(resolvableTypes[i].getGenerics(), contextClass);
            if (resolvableTypes[i].getRawClass() == null) continue;
            resolvableTypes[i] = ResolvableType.forClassWithGenerics((Class)Objects.requireNonNull(resolvableTypes[i].getRawClass()), (ResolvableType[])resolvableTypes[i].getGenerics());
        }
    }

    public static ResolvableType getResolvedType(ResolvableType resolvableType, Class<?> contextClass) {
        ParameterizedType parameterizedType = (ParameterizedType)resolvableType.getType();
        Class[] generics = new Class[parameterizedType.getActualTypeArguments().length];
        Type[] typeArguments = parameterizedType.getActualTypeArguments();
        ResolvableType contextType = ResolvableType.forClass(contextClass);
        ReturnTypeParser.findTypeForGenerics(generics, typeArguments, contextType);
        Class rawClass = resolvableType.getRawClass();
        if (rawClass != null) {
            return ResolvableType.forClassWithGenerics((Class)rawClass, (Class[])generics);
        }
        return null;
    }

    public static void findTypeForGenerics(Class<?>[] generics, Type[] typeArguments, ResolvableType contextType) {
        for (int i = 0; i < typeArguments.length; ++i) {
            Type typeArgument = typeArguments[i];
            if (typeArgument instanceof TypeVariable) {
                ResolvableType resolvedTypeArgument = ReturnTypeParser.resolveVariable((TypeVariable)typeArgument, contextType);
                if (resolvedTypeArgument != ResolvableType.NONE) {
                    generics[i] = resolvedTypeArgument.resolve();
                    continue;
                }
                generics[i] = ResolvableType.forType((Type)typeArgument).resolve();
                continue;
            }
            generics[i] = ResolvableType.forType((Type)typeArgument).resolve();
        }
    }

    public static ResolvableType resolveVariable(TypeVariable<?> typeVariable, ResolvableType contextType) {
        ResolvableType resolvedType;
        if (contextType.hasGenerics() && Objects.equals(contextType.getRawClass(), typeVariable.getGenericDeclaration()) && (resolvedType = ResolvableType.forType(typeVariable, (ResolvableType)contextType)).resolve() != null) {
            return resolvedType;
        }
        ResolvableType superType = contextType.getSuperType();
        if (superType != ResolvableType.NONE && (resolvedType = ReturnTypeParser.resolveVariable(typeVariable, superType)).resolve() != null) {
            return resolvedType;
        }
        for (ResolvableType ifc : contextType.getInterfaces()) {
            resolvedType = ReturnTypeParser.resolveVariable(typeVariable, ifc);
            if (resolvedType.resolve() == null) continue;
            return resolvedType;
        }
        return ResolvableType.NONE;
    }

    default public Type getReturnType(MethodParameter methodParameter) {
        if (methodParameter.getGenericParameterType() instanceof ParameterizedType) {
            return ReturnTypeParser.resolveType(methodParameter.getGenericParameterType(), methodParameter.getContainingClass());
        }
        return methodParameter.getParameterType();
    }

    public static Type getType(MethodParameter methodParameter) {
        Type genericParameterType = methodParameter.getGenericParameterType();
        if (genericParameterType instanceof ParameterizedType || genericParameterType instanceof TypeVariable) {
            return ReturnTypeParser.resolveType(genericParameterType, methodParameter.getContainingClass());
        }
        return methodParameter.getParameterType();
    }
}

