/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.form.slider;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.ui.JQueryUIBehavior;
import com.googlecode.wicket.jquery.ui.form.slider.Orientation;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.validation.validator.RangeValidator;

public abstract class AbstractSlider<T>
extends FormComponentPanel<T>
implements IJQueryWidget {
    private static final long serialVersionUID = 1L;
    protected Options options;
    protected Label label;
    protected String labelId = null;

    public AbstractSlider(String id) {
        super(id);
    }

    public AbstractSlider(String id, IModel<T> model) {
        super(id, model);
    }

    public AbstractSlider(String id, IModel<T> model, Label label) {
        super(id, model);
        label.setDefaultModel(model);
        label.setOutputMarkupId(true);
        this.setLabelId(label.getMarkupId());
    }

    void initialize() {
        this.options = new Options();
        this.label = new Label("slider", (Serializable)((Object)""));
        this.add(new Component[]{this.label});
    }

    public abstract void convertInput();

    public abstract AbstractSlider<T> setRangeValidator(RangeValidator<Integer> var1);

    public final AbstractSlider<T> setLabelId(String markupId) {
        this.labelId = markupId;
        return this;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.newInputFragment("model")});
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior((IJQueryWidget)this, (Component)this.label)});
    }

    public void onConfigure(JQueryBehavior behavior) {
    }

    public void onBeforeRender(JQueryBehavior behavior) {
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new SliderBehavior(selector, this.options);
    }

    protected Fragment newInputFragment(String id) {
        return new Fragment(id, "empty-fragment", (MarkupContainer)this);
    }

    public AbstractSlider<T> setMin(Integer min) {
        this.options.set("min", (Object)min);
        return this;
    }

    public AbstractSlider<T> setMax(Integer max) {
        this.options.set("max", (Object)max);
        return this;
    }

    public AbstractSlider<T> setStep(Integer step) {
        this.options.set("step", (Object)step);
        return this;
    }

    public AbstractSlider<T> setOrientation(Orientation orientation) {
        this.options.set("orientation", (Object)orientation);
        return this;
    }

    public static class SliderBehavior
    extends JQueryUIBehavior {
        private static final long serialVersionUID = 1L;
        public static final String METHOD = "slider";

        public SliderBehavior(String selector) {
            super(selector, METHOD);
        }

        public SliderBehavior(String selector, Options options) {
            super(selector, METHOD, options);
        }
    }
}

