/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.Filter;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditPrincipalIdProvider;
import org.apereo.cas.audit.AuditTrailExecutionPlan;
import org.apereo.cas.audit.AuditTrailExecutionPlanConfigurer;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlan;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlanConfigurer;
import org.apereo.cas.audit.spi.plan.DefaultAuditTrailExecutionPlan;
import org.apereo.cas.audit.spi.plan.DefaultAuditTrailRecordResolutionPlan;
import org.apereo.cas.audit.spi.principal.ChainingAuditPrincipalIdProvider;
import org.apereo.cas.audit.spi.principal.ThreadLocalAuditPrincipalResolver;
import org.apereo.cas.audit.spi.resource.CredentialsAsFirstParameterResourceResolver;
import org.apereo.cas.audit.spi.resource.LogoutRequestResourceResolver;
import org.apereo.cas.audit.spi.resource.ProtocolSpecificationValidationAuditResourceResolver;
import org.apereo.cas.audit.spi.resource.ServiceAccessEnforcementAuditResourceResolver;
import org.apereo.cas.audit.spi.resource.ServiceAuditResourceResolver;
import org.apereo.cas.audit.spi.resource.TicketAsFirstParameterResourceResolver;
import org.apereo.cas.audit.spi.resource.TicketValidationResourceResolver;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.audit.AuditEngineProperties;
import org.apereo.cas.configuration.model.core.audit.AuditSlf4jLogProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.util.text.MessageSanitizer;
import org.apereo.inspektr.audit.AuditTrailManagementAspect;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.apereo.inspektr.audit.FilterAndDelegateAuditTrailManager;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.apereo.inspektr.audit.spi.support.BooleanAuditActionResolver;
import org.apereo.inspektr.audit.spi.support.DefaultAuditActionResolver;
import org.apereo.inspektr.audit.spi.support.MessageBundleAwareResourceResolver;
import org.apereo.inspektr.audit.spi.support.NullableReturnValueAuditResourceResolver;
import org.apereo.inspektr.audit.spi.support.ObjectCreationAuditActionResolver;
import org.apereo.inspektr.audit.spi.support.ShortenedReturnValueAsStringAuditResourceResolver;
import org.apereo.inspektr.audit.support.Slf4jLoggingAuditTrailManager;
import org.apereo.inspektr.common.spi.PrincipalResolver;
import org.apereo.inspektr.common.web.ClientInfoThreadLocalFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.audit.AuditEventRepository;
import org.springframework.boot.actuate.audit.InMemoryAuditEventRepository;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.PropertyResolver;

@EnableAspectJAutoProxy(proxyTargetClass=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.Audit)
@AutoConfiguration(after={CasCoreServicesConfiguration.class})
public class CasCoreAuditConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreAuditConfiguration.class);
    private static final BeanCondition CONDITION_AUDIT = BeanCondition.on((String)"cas.audit.engine.enabled").isTrue().evenIfMissing();

    @Configuration(value="CasCoreAuditExecutionPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @AutoConfigureOrder(value=0x7FFFFFFF)
    public static class CasCoreAuditExecutionPlanConfiguration {
        @ConditionalOnMissingBean(name={"auditTrailExecutionPlan"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditTrailExecutionPlan auditTrailExecutionPlan(List<AuditTrailExecutionPlanConfigurer> configurers) {
            DefaultAuditTrailExecutionPlan plan = new DefaultAuditTrailExecutionPlan();
            configurers.stream().filter(BeanSupplier::isNotProxy).forEach(c -> {
                LOGGER.trace("Configuring audit trail execution plan via [{}]", (Object)c.getName());
                c.configureAuditTrailExecutionPlan((AuditTrailExecutionPlan)plan);
            });
            return plan;
        }

        @Bean
        @ConditionalOnMissingBean(name={"casAuditTrailExecutionPlanConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditTrailExecutionPlanConfigurer casAuditTrailExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) throws Exception {
            return (AuditTrailExecutionPlanConfigurer)BeanSupplier.of(AuditTrailExecutionPlanConfigurer.class).when(BeanCondition.on((String)"cas.audit.slf4j.enabled").isTrue().evenIfMissing().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> {
                AuditSlf4jLogProperties slf4j = casProperties.getAudit().getSlf4j();
                Slf4jLoggingAuditTrailManager slf4jManager = new Slf4jLoggingAuditTrailManager();
                slf4jManager.setUseSingleLine(slf4j.isUseSingleLine());
                slf4jManager.setEntrySeparator(slf4j.getSinglelineSeparator());
                plan.registerAuditTrailManager((AuditTrailManager)slf4jManager);
            }).otherwiseProxy().get();
        }
    }

    @Configuration(value="CasCoreAuditResolutionPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @AutoConfigureOrder(value=0x7FFFFFFF)
    public static class CasCoreAuditResolutionPlanConfiguration {
        @ConditionalOnMissingBean(name={"auditTrailRecordResolutionPlan"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditTrailRecordResolutionPlan auditTrailRecordResolutionPlan(List<AuditTrailRecordResolutionPlanConfigurer> configurers) {
            DefaultAuditTrailRecordResolutionPlan plan = new DefaultAuditTrailRecordResolutionPlan();
            configurers.stream().filter(BeanSupplier::isNotProxy).forEach(c -> {
                LOGGER.trace("Registering audit trail manager [{}]", (Object)c.getName());
                c.configureAuditTrailRecordResolutionPlan((AuditTrailRecordResolutionPlan)plan);
            });
            return plan;
        }

        @Bean
        @ConditionalOnMissingBean(name={"casAuditResourceResolversResolutionPlanConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditTrailRecordResolutionPlanConfigurer casAuditResourceResolversResolutionPlanConfigurer(@Qualifier(value="credentialsAsFirstParameterResourceResolver") AuditResourceResolver credentialsAsFirstParameterResourceResolver, @Qualifier(value="nullableReturnValueResourceResolver") AuditResourceResolver nullableReturnValueResourceResolver, @Qualifier(value="messageBundleAwareResourceResolver") AuditResourceResolver messageBundleAwareResourceResolver, @Qualifier(value="returnValueResourceResolver") AuditResourceResolver returnValueResourceResolver, @Qualifier(value="ticketResourceResolver") AuditResourceResolver ticketResourceResolver, @Qualifier(value="serviceAccessEnforcementAuditResourceResolver") AuditResourceResolver serviceAccessEnforcementAuditResourceResolver, @Qualifier(value="serviceAuditResourceResolver") AuditResourceResolver serviceAuditResourceResolver, @Qualifier(value="ticketValidationResourceResolver") AuditResourceResolver ticketValidationResourceResolver, @Qualifier(value="protocolSpecificationValidationResourceResolver") AuditResourceResolver protocolSpecificationValidationResourceResolver, @Qualifier(value="logoutRequestResourceResolver") AuditResourceResolver logoutRequestResourceResolver) {
            return plan -> {
                plan.registerAuditResourceResolver("AUTHENTICATION_RESOURCE_RESOLVER", credentialsAsFirstParameterResourceResolver);
                plan.registerAuditResourceResolver("AUTHENTICATION_EVENT_RESOURCE_RESOLVER", nullableReturnValueResourceResolver);
                plan.registerAuditResourceResolvers(messageBundleAwareResourceResolver, new String[]{"CREATE_TICKET_GRANTING_TICKET_RESOURCE_RESOLVER", "CREATE_PROXY_GRANTING_TICKET_RESOURCE_RESOLVER"});
                plan.registerAuditResourceResolvers(ticketResourceResolver, new String[]{"DESTROY_TICKET_RESOURCE_RESOLVER", "DESTROY_PROXY_GRANTING_TICKET_RESOURCE_RESOLVER"});
                plan.registerAuditResourceResolver(serviceAuditResourceResolver, new String[]{"GRANT_SERVICE_TICKET_RESOURCE_RESOLVER", "GRANT_PROXY_TICKET_RESOURCE_RESOLVER"});
                plan.registerAuditResourceResolver("VALIDATE_SERVICE_TICKET_RESOURCE_RESOLVER", ticketValidationResourceResolver);
                plan.registerAuditResourceResolver("VALIDATE_PROTOCOL_SPECIFICATION_RESOURCE_RESOLVER", protocolSpecificationValidationResourceResolver);
                plan.registerAuditResourceResolvers(returnValueResourceResolver, new String[]{"SAVE_SERVICE_RESOURCE_RESOLVER", "DELETE_SERVICE_RESOURCE_RESOLVER"});
                plan.registerAuditResourceResolver("SERVICE_ACCESS_ENFORCEMENT_RESOURCE_RESOLVER", serviceAccessEnforcementAuditResourceResolver);
                plan.registerAuditResourceResolver("LOGOUT_RESOURCE_RESOLVER", logoutRequestResourceResolver);
            };
        }

        @Bean
        @ConditionalOnMissingBean(name={"casAuditActionResolversResolutionPlanConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditTrailRecordResolutionPlanConfigurer casAuditActionResolversResolutionPlanConfigurer(@Qualifier(value="authenticationActionResolver") AuditActionResolver authenticationActionResolver, @Qualifier(value="objectCreationAuditActionResolver") AuditActionResolver objectCreationAuditActionResolver, @Qualifier(value="defaultAuditActionResolver") AuditActionResolver defaultAuditActionResolver, @Qualifier(value="ticketCreationActionResolver") AuditActionResolver ticketCreationActionResolver, @Qualifier(value="triggeredAuditActionResolver") AuditActionResolver triggeredAuditActionResolver, @Qualifier(value="ticketValidationActionResolver") AuditActionResolver ticketValidationActionResolver, @Qualifier(value="booleanActionResolver") AuditActionResolver booleanActionResolver, @Qualifier(value="logoutAuditActionResolver") AuditActionResolver logoutAuditActionResolver) {
            return plan -> {
                plan.registerAuditActionResolvers(authenticationActionResolver, new String[]{"AUTHENTICATION_RESOLVER", "SAVE_SERVICE_ACTION_RESOLVER"});
                plan.registerAuditActionResolvers(ticketCreationActionResolver, new String[]{"CREATE_PROXY_GRANTING_TICKET_RESOLVER", "GRANT_PROXY_TICKET_RESOLVER", "CREATE_TICKET_GRANTING_TICKET_RESOLVER", "GRANT_SERVICE_TICKET_RESOLVER"});
                plan.registerAuditActionResolver("DELETE_SERVICE_ACTION_RESOLVER", objectCreationAuditActionResolver);
                plan.registerAuditActionResolvers(defaultAuditActionResolver, new String[]{"DESTROY_TICKET_RESOLVER", "DESTROY_PROXY_GRANTING_TICKET_RESOLVER"});
                plan.registerAuditActionResolvers(triggeredAuditActionResolver, new String[]{"AUTHENTICATION_EVENT_ACTION_RESOLVER", "SERVICE_ACCESS_ENFORCEMENT_ACTION_RESOLVER"});
                plan.registerAuditActionResolver("VALIDATE_SERVICE_TICKET_RESOLVER", ticketValidationActionResolver);
                plan.registerAuditActionResolver("VALIDATE_PROTOCOL_SPECIFICATION_RESOLVER", booleanActionResolver);
                plan.registerAuditActionResolver("LOGOUT_ACTION_RESOLVER", logoutAuditActionResolver);
            };
        }
    }

    @Configuration(value="CasCoreAuditFiltersConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreAuditFiltersConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"casClientInfoLoggingFilter"})
        public FilterRegistrationBean<ClientInfoThreadLocalFilter> casClientInfoLoggingFilter(CasConfigurationProperties casProperties) {
            AuditEngineProperties audit = casProperties.getAudit().getEngine();
            FilterRegistrationBean bean = new FilterRegistrationBean();
            bean.setFilter((Filter)new ClientInfoThreadLocalFilter());
            bean.setUrlPatterns((Collection)CollectionUtils.wrap((Object)"/*"));
            bean.setName("CAS Client Info Logging Filter");
            bean.setAsyncSupported(true);
            bean.setOrder(-2147483647);
            HashMap<String, String> initParams = new HashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)audit.getAlternateClientAddrHeaderName())) {
                initParams.put("alternativeIpAddressHeader", audit.getAlternateClientAddrHeaderName());
            }
            if (StringUtils.isNotBlank((CharSequence)audit.getAlternateServerAddrHeaderName())) {
                initParams.put("alternateServerAddrHeaderName", audit.getAlternateServerAddrHeaderName());
            }
            initParams.put("useServerHostAddress", String.valueOf(audit.isUseServerHostAddress()));
            bean.setInitParameters(initParams);
            return bean;
        }
    }

    @Configuration(value="CasCoreAuditManagementConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreAuditManagementConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"auditTrailManagementAspect"})
        public AuditTrailManagementAspect auditTrailManagementAspect(@Qualifier(value="auditTrailRecordResolutionPlan") AuditTrailRecordResolutionPlan auditTrailRecordResolutionPlan, @Qualifier(value="auditablePrincipalResolver") PrincipalResolver auditablePrincipalResolver, @Qualifier(value="filterAndDelegateAuditTrailManager") AuditTrailManager filterAndDelegateAuditTrailManager, CasConfigurationProperties casProperties) {
            AuditEngineProperties audit = casProperties.getAudit().getEngine();
            AuditTrailManager.AuditFormats auditFormat = AuditTrailManager.AuditFormats.valueOf((String)audit.getAuditFormat().name());
            AuditTrailManagementAspect aspect = new AuditTrailManagementAspect(audit.getAppCode(), auditablePrincipalResolver, CollectionUtils.wrapList((Object[])new AuditTrailManager[]{filterAndDelegateAuditTrailManager}), auditTrailRecordResolutionPlan.getAuditActionResolvers(), auditTrailRecordResolutionPlan.getAuditResourceResolvers(), auditTrailRecordResolutionPlan.getAuditPrincipalResolvers(), auditFormat);
            aspect.setFailOnAuditFailures(!audit.isIgnoreAuditFailures());
            aspect.setEnabled(casProperties.getAudit().getEngine().isEnabled());
            return aspect;
        }

        @Bean
        @ConditionalOnMissingBean(name={"filterAndDelegateAuditTrailManager"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        protected AuditTrailManager filterAndDelegateAuditTrailManager(ConfigurableApplicationContext applicationContext, @Qualifier(value="auditTrailExecutionPlan") AuditTrailExecutionPlan auditTrailExecutionPlan, CasConfigurationProperties casProperties) throws Exception {
            return (AuditTrailManager)BeanSupplier.of(AuditTrailManager.class).when(CONDITION_AUDIT.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                AuditEngineProperties audit = casProperties.getAudit().getEngine();
                AuditTrailManager.AuditFormats auditFormat = AuditTrailManager.AuditFormats.valueOf((String)audit.getAuditFormat().name());
                FilterAndDelegateAuditTrailManager auditManager = new FilterAndDelegateAuditTrailManager((Collection)auditTrailExecutionPlan.getAuditTrailManagers(), audit.getSupportedActions(), audit.getExcludedActions());
                auditManager.setAuditFormat(auditFormat);
                return auditManager;
            }).otherwiseProxy().get();
        }
    }

    @Configuration(value="CasCoreAuditEventsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreAuditEventsConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"inMemoryAuditEventRepository"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditEventRepository inMemoryAuditEventRepository(ConfigurableApplicationContext applicationContext) throws Exception {
            return (AuditEventRepository)BeanSupplier.of(AuditEventRepository.class).when(CONDITION_AUDIT.given((PropertyResolver)applicationContext.getEnvironment())).supply(InMemoryAuditEventRepository::new).otherwiseProxy().get();
        }
    }

    @Configuration(value="CasCoreAuditActionsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreAuditActionsConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"defaultAuditActionResolver"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditActionResolver defaultAuditActionResolver() {
            return new DefaultAuditActionResolver();
        }

        @Bean
        @ConditionalOnMissingBean(name={"triggeredAuditActionResolver"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditActionResolver triggeredAuditActionResolver() {
            return new DefaultAuditActionResolver("_TRIGGERED");
        }

        @Bean
        @ConditionalOnMissingBean(name={"objectCreationAuditActionResolver"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditActionResolver objectCreationAuditActionResolver() {
            return new ObjectCreationAuditActionResolver("_SUCCESS", "_FAILED");
        }

        @Bean
        @ConditionalOnMissingBean(name={"booleanActionResolver"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditActionResolver booleanActionResolver() {
            return new BooleanAuditActionResolver("_SUCCESS", "_FAILED");
        }

        @ConditionalOnMissingBean(name={"authenticationActionResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditActionResolver authenticationActionResolver() {
            return new DefaultAuditActionResolver("_SUCCESS", "_FAILED");
        }

        @ConditionalOnMissingBean(name={"ticketCreationActionResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditActionResolver ticketCreationActionResolver() {
            return new DefaultAuditActionResolver("_CREATED", "_NOT_CREATED");
        }

        @ConditionalOnMissingBean(name={"ticketValidationActionResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditActionResolver ticketValidationActionResolver() {
            return new DefaultAuditActionResolver("_SUCCESS", "_FAILED");
        }

        @ConditionalOnMissingBean(name={"logoutAuditActionResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditActionResolver logoutAuditActionResolver() {
            return new DefaultAuditActionResolver("_SUCCESS", "_FAILED");
        }
    }

    @Configuration(value="CasCoreAuditResourcesConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreAuditResourcesConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"credentialsAsFirstParameterResourceResolver"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditResourceResolver credentialsAsFirstParameterResourceResolver() {
            return new CredentialsAsFirstParameterResourceResolver();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"protocolSpecificationValidationResourceResolver"})
        public AuditResourceResolver protocolSpecificationValidationResourceResolver(CasConfigurationProperties casProperties) {
            return new ProtocolSpecificationValidationAuditResourceResolver(casProperties);
        }

        @ConditionalOnMissingBean(name={"ticketResourceResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditResourceResolver ticketResourceResolver(@Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan) {
            return new TicketAsFirstParameterResourceResolver(authenticationServiceSelectionPlan);
        }

        @ConditionalOnMissingBean(name={"ticketValidationResourceResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditResourceResolver ticketValidationResourceResolver(@Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, @Qualifier(value="ticketResourceResolver") AuditResourceResolver ticketResourceResolver, CasConfigurationProperties casProperties) {
            if (casProperties.getAudit().getEngine().isIncludeValidationAssertion()) {
                return new TicketValidationResourceResolver(authenticationServiceSelectionPlan);
            }
            return ticketResourceResolver;
        }

        @ConditionalOnMissingBean(name={"messageBundleAwareResourceResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditResourceResolver messageBundleAwareResourceResolver(@Qualifier(value="messageSanitizer") MessageSanitizer messageSanitizer, ConfigurableApplicationContext applicationContext) {
            MessageBundleAwareResourceResolver resolver = new MessageBundleAwareResourceResolver((ApplicationContext)applicationContext);
            resolver.setResourcePostProcessor(inputs -> (String[])Arrays.stream(inputs).map(arg_0 -> ((MessageSanitizer)messageSanitizer).sanitize(arg_0)).toArray(String[]::new));
            return resolver;
        }

        @ConditionalOnMissingBean(name={"serviceAuditResourceResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditResourceResolver serviceAuditResourceResolver(CasConfigurationProperties properties) {
            return new ServiceAuditResourceResolver(properties.getAudit().getEngine());
        }

        @ConditionalOnMissingBean(name={"returnValueResourceResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditResourceResolver returnValueResourceResolver() {
            return new ShortenedReturnValueAsStringAuditResourceResolver();
        }

        @ConditionalOnMissingBean(name={"nullableReturnValueResourceResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditResourceResolver nullableReturnValueResourceResolver(@Qualifier(value="messageSanitizer") MessageSanitizer messageSanitizer) {
            NullableReturnValueAuditResourceResolver resolver = new NullableReturnValueAuditResourceResolver((AuditResourceResolver)new ShortenedReturnValueAsStringAuditResourceResolver());
            resolver.setResourcePostProcessor(inputs -> (String[])Arrays.stream(inputs).map(arg_0 -> ((MessageSanitizer)messageSanitizer).sanitize(arg_0)).toArray(String[]::new));
            return resolver;
        }

        @ConditionalOnMissingBean(name={"serviceAccessEnforcementAuditResourceResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditResourceResolver serviceAccessEnforcementAuditResourceResolver(@Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, CasConfigurationProperties properties) {
            return new ServiceAccessEnforcementAuditResourceResolver(authenticationServiceSelectionPlan, properties.getAudit().getEngine());
        }

        @ConditionalOnMissingBean(name={"logoutRequestResourceResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditResourceResolver logoutRequestResourceResolver() {
            return new LogoutRequestResourceResolver();
        }
    }

    @Configuration(value="CasCoreAuditPrincipalConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreAuditPrincipalConfiguration {
        @ConditionalOnMissingBean(name={"auditablePrincipalResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalResolver auditablePrincipalResolver(@Qualifier(value="auditPrincipalIdProvider") AuditPrincipalIdProvider auditPrincipalIdProvider) {
            return new ThreadLocalAuditPrincipalResolver(auditPrincipalIdProvider);
        }

        @ConditionalOnMissingBean(name={"auditPrincipalIdProvider"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditPrincipalIdProvider auditPrincipalIdProvider(List<AuditPrincipalIdProvider> providers) {
            AnnotationAwareOrderComparator.sortIfNecessary(providers);
            return new ChainingAuditPrincipalIdProvider(providers);
        }
    }
}

