/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.error;

import com.okta.sdk.error.Error;
import com.okta.sdk.error.ErrorCause;
import com.okta.sdk.impl.error.DefaultErrorCause;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.StringProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DefaultError
extends AbstractResource
implements Error {
    static final long serialVersionUID = 42L;
    static final IntegerProperty STATUS = new IntegerProperty("status");
    static final StringProperty CODE = new StringProperty("errorCode");
    static final StringProperty MESSAGE = new StringProperty("errorSummary");
    static final ListProperty CAUSES = new ListProperty("errorCauses");
    static final MapProperty HEADERS = new MapProperty("errorHeaders");
    public static final StringProperty ERROR_ID = new StringProperty("errorId");
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultError.createPropertyDescriptorMap(STATUS, CODE, MESSAGE, CAUSES, ERROR_ID, HEADERS);

    public DefaultError(Map<String, Object> body) {
        super(null, body);
    }

    public DefaultError() {
        super(null, null);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public int getStatus() {
        return this.getInt(STATUS);
    }

    public DefaultError setStatus(int status) {
        this.setProperty(STATUS, (Object)status);
        return this;
    }

    public String getCode() {
        return this.getString(CODE);
    }

    public DefaultError setCode(String code) {
        this.setProperty(CODE, (Object)code);
        return this;
    }

    public String getMessage() {
        return this.getString(MESSAGE);
    }

    public DefaultError setMessage(String message) {
        this.setProperty(MESSAGE, (Object)message);
        return this;
    }

    public String getId() {
        return this.getString(ERROR_ID);
    }

    public DefaultError setId(String requestId) {
        this.setProperty(ERROR_ID, (Object)requestId);
        return this;
    }

    public List<ErrorCause> getCauses() {
        ArrayList results = new ArrayList();
        Object rawProp = this.getProperty(CAUSES.getName());
        if (rawProp instanceof List) {
            ((List)rawProp).forEach(causeMap -> results.add(new DefaultErrorCause(this.getDataStore(), (Map<String, Object>)causeMap)));
        }
        return Collections.unmodifiableList(results);
    }

    public DefaultError setCauses(Map<String, String> causes) {
        this.setProperty(CAUSES, causes);
        return this;
    }

    public Map<String, List<String>> getHeaders() {
        return this.getMap(HEADERS);
    }

    public DefaultError setHeaders(Map<String, List<String>> headers) {
        this.setProperty(HEADERS, headers);
        return this;
    }
}

