/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.flowable.impl;

import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.syncope.core.workflow.api.WorkflowException;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.editor.language.json.converter.BpmnJsonConverter;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.Model;
import org.flowable.engine.repository.ProcessDefinition;

public final class FlowableDeployUtils {
    private static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    private static final XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory.newInstance();

    public static Deployment deployDefinition(ProcessEngine engine, String resourceName, byte[] definition) {
        try {
            return engine.getRepositoryService().createDeployment().addInputStream(resourceName, (InputStream)new ByteArrayInputStream(definition)).deploy();
        }
        catch (FlowableException e) {
            throw new WorkflowException("While importing " + resourceName, (Throwable)e);
        }
    }

    public static void deployModel(ProcessEngine engine, ProcessDefinition procDef) {
        XMLStreamReader xtr = null;
        try (InputStream bpmnStream = engine.getRepositoryService().getResourceAsStream(procDef.getDeploymentId(), procDef.getResourceName());
             InputStreamReader isr = new InputStreamReader(bpmnStream);){
            xtr = XML_INPUT_FACTORY.createXMLStreamReader(isr);
            BpmnModel bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
            Model model = engine.getRepositoryService().newModel();
            ObjectNode modelObjectNode = MAPPER.createObjectNode();
            modelObjectNode.put("name", procDef.getName());
            model.setMetaInfo(modelObjectNode.toString());
            model.setName(procDef.getName());
            model.setDeploymentId(procDef.getDeploymentId());
            model.setVersion(Integer.valueOf(procDef.getVersion()));
            engine.getRepositoryService().saveModel(model);
            engine.getRepositoryService().addModelEditorSource(model.getId(), new BpmnJsonConverter().convertToJson(bpmnModel).toString().getBytes());
        }
        catch (Exception e) {
            throw new WorkflowException("While importing " + procDef.getResourceName(), (Throwable)e);
        }
        finally {
            if (xtr != null) {
                try {
                    xtr.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
    }

    private FlowableDeployUtils() {
    }

    static {
        XML_INPUT_FACTORY.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        XML_INPUT_FACTORY.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
    }
}

