/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.configuration.extensions.stuff.restannotations;

import com.giffing.wicket.spring.boot.context.extensions.ApplicationInitExtension;
import com.giffing.wicket.spring.boot.context.extensions.WicketApplicationInitConfiguration;
import com.giffing.wicket.spring.boot.starter.app.classscanner.candidates.WicketClassCandidatesHolder;
import com.giffing.wicket.spring.boot.starter.configuration.extensions.stuff.restannotations.RestAnnotationsProperties;
import org.apache.wicket.protocol.http.WebApplication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.wicketstuff.rest.utils.mounting.PackageScanner;

@ApplicationInitExtension
@ConditionalOnProperty(prefix="wicket.stuff.restannotations", value={"enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={PackageScanner.class})
@EnableConfigurationProperties(value={RestAnnotationsProperties.class})
public class RestAnnotationsConfig
implements WicketApplicationInitConfiguration {
    @Autowired
    private RestAnnotationsProperties prop;
    @Autowired
    private WicketClassCandidatesHolder candidates;

    public void init(WebApplication webApplication) {
        String packagename = webApplication.getClass().getPackage().getName();
        if (this.prop.getPackagename() != null) {
            packagename = this.prop.getPackagename();
        }
        PackageScanner.scanPackage((WebApplication)webApplication, (String)packagename);
        for (String basePackage : this.candidates.getBasePackages()) {
            PackageScanner.scanPackage((WebApplication)webApplication, (String)basePackage);
        }
    }
}

