/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.badge;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.core.util.Components;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;

public class BadgeBehavior
extends Behavior {
    private Type type;
    private boolean isPill;

    public BadgeBehavior() {
        this(Type.Secondary, false);
    }

    public BadgeBehavior(Type type) {
        this(type, false);
    }

    public BadgeBehavior(Type type, boolean isPill) {
        this.type = type;
        this.isPill = isPill;
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        Components.assertTag(component, tag, "span", "a");
        Attributes.addClass(tag, this.className(), this.type.cssClassName());
        if (this.isPill) {
            Attributes.addClass(tag, this.pillClassName());
        }
    }

    public void bind(Component component) {
        super.bind(component);
        BootstrapBaseBehavior.addTo(component);
    }

    public void unbind(Component component) {
        super.unbind(component);
        BootstrapBaseBehavior.removeFrom(component);
    }

    protected String pillClassName() {
        return "badge-pill";
    }

    protected String className() {
        return "badge";
    }

    public BadgeBehavior pill(boolean isPill) {
        this.isPill = isPill;
        return this;
    }

    public BadgeBehavior type(Type type) {
        this.type = type;
        return this;
    }

    public static enum Type {
        Primary("primary"),
        Secondary("secondary"),
        Success("success"),
        Danger("danger"),
        Warning("warning"),
        Info("info"),
        Light("light"),
        Dark("dark");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String cssClassName() {
            return String.format("badge-%s", this.value);
        }
    }
}

