/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.bootstrap;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.attr.AttrRepoConf;
import org.apache.syncope.common.lib.auth.AuthModuleConf;
import org.apache.syncope.common.lib.to.OIDCRPClientAppTO;
import org.apache.syncope.common.rest.api.service.AttrRepoService;
import org.apache.syncope.common.rest.api.service.AuthModuleService;
import org.apache.syncope.common.rest.api.service.wa.WAClientAppService;
import org.apache.syncope.common.rest.api.service.wa.WAConfigService;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.apache.syncope.wa.bootstrap.mapping.AttrReleaseMapper;
import org.apache.syncope.wa.bootstrap.mapping.AttrRepoPropertySourceMapper;
import org.apache.syncope.wa.bootstrap.mapping.AuthModulePropertySourceMapper;
import org.apereo.cas.configuration.model.support.oidc.OidcDiscoveryProperties;
import org.apereo.cas.oidc.claims.OidcAddressScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcEmailScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcPhoneScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcProfileScopeAttributeReleasePolicy;
import org.apereo.cas.services.BaseMappedAttributeReleasePolicy;
import org.apereo.cas.services.ChainingAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.ReturnAllowedAttributeReleasePolicy;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

@Order
public class WAPropertySourceLocator
implements PropertySourceLocator {
    protected static final Logger LOG = LoggerFactory.getLogger(WAPropertySourceLocator.class);
    protected final WARestClient waRestClient;
    protected final AuthModulePropertySourceMapper authModulePropertySourceMapper;
    protected final AttrRepoPropertySourceMapper attrRepoPropertySourceMapper;
    protected final AttrReleaseMapper attrReleaseMapper;
    protected final CipherExecutor<String, String> configurationCipher;

    public WAPropertySourceLocator(WARestClient waRestClient, AuthModulePropertySourceMapper authModulePropertySourceMapper, AttrRepoPropertySourceMapper attrRepoPropertySourceMapper, AttrReleaseMapper attrReleaseMapper, CipherExecutor<String, String> configurationCipher) {
        this.waRestClient = waRestClient;
        this.authModulePropertySourceMapper = authModulePropertySourceMapper;
        this.attrRepoPropertySourceMapper = attrRepoPropertySourceMapper;
        this.attrReleaseMapper = attrReleaseMapper;
        this.configurationCipher = configurationCipher;
    }

    protected Map<String, Object> index(Map<String, Object> map, Map<String, Integer> prefixes) {
        String prefix;
        Map<String, Object> indexed = map;
        if (!map.isEmpty() && (prefix = map.keySet().iterator().next()).contains("[]")) {
            prefix = StringUtils.substringBefore((String)prefix, (String)"[]");
            Integer index = prefixes.getOrDefault(prefix, 0);
            indexed = map.entrySet().stream().map(e -> Pair.of((Object)((String)e.getKey()).replace("[]", "[" + index + "]"), e.getValue())).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
            prefixes.put(prefix, index + 1);
        }
        return indexed;
    }

    public PropertySource<?> locate(Environment environment) {
        SyncopeClient syncopeClient = this.waRestClient.getSyncopeClient();
        if (syncopeClient == null) {
            LOG.warn("Application context is not ready to bootstrap WA configuration");
            return null;
        }
        LOG.info("Bootstrapping WA configuration");
        TreeMap<String, String> properties = new TreeMap<String, String>();
        HashMap prefixes = new HashMap();
        ((AuthModuleService)syncopeClient.getService(AuthModuleService.class)).list().forEach(authModuleTO -> {
            LOG.debug("Mapping auth module {} ", (Object)authModuleTO.getKey());
            Map map = authModuleTO.getConf().map(authModuleTO, (AuthModuleConf.Mapper)this.authModulePropertySourceMapper);
            properties.putAll(this.index(map, prefixes));
        });
        ((AttrRepoService)syncopeClient.getService(AttrRepoService.class)).list().forEach(attrRepoTO -> {
            LOG.debug("Mapping attr repo {} ", (Object)attrRepoTO.getKey());
            Map map = attrRepoTO.getConf().map(attrRepoTO, (AttrRepoConf.Mapper)this.attrRepoPropertySourceMapper);
            properties.putAll(this.index(map, prefixes));
        });
        Set customClaims = ((WAClientAppService)syncopeClient.getService(WAClientAppService.class)).list().stream().filter(clientApp -> clientApp.getAttrReleasePolicy() != null && clientApp.getClientAppTO() instanceof OIDCRPClientAppTO).flatMap(clientApp -> {
            OIDCRPClientAppTO rp = (OIDCRPClientAppTO)OIDCRPClientAppTO.class.cast(clientApp.getClientAppTO());
            RegisteredServiceAttributeReleasePolicy attributeReleasePolicy = this.attrReleaseMapper.build(clientApp.getAttrReleasePolicy());
            HashSet claims = new HashSet();
            if (attributeReleasePolicy instanceof BaseMappedAttributeReleasePolicy) {
                claims.addAll(((BaseMappedAttributeReleasePolicy)attributeReleasePolicy).getAllowedAttributes().values().stream().map(Objects::toString).collect(Collectors.toSet()));
            } else if (attributeReleasePolicy instanceof ReturnAllowedAttributeReleasePolicy) {
                claims.addAll(((ReturnAllowedAttributeReleasePolicy)attributeReleasePolicy).getAllowedAttributes().stream().collect(Collectors.toSet()));
            } else if (attributeReleasePolicy instanceof ChainingAttributeReleasePolicy) {
                ((ChainingAttributeReleasePolicy)attributeReleasePolicy).getPolicies().stream().filter(ReturnAllowedAttributeReleasePolicy.class::isInstance).findFirst().map(ReturnAllowedAttributeReleasePolicy.class::cast).map(p -> p.getAllowedAttributes().stream().collect(Collectors.toSet())).ifPresent(claims::addAll);
            }
            if (rp.getScopes().contains("profile")) {
                claims.removeAll(OidcProfileScopeAttributeReleasePolicy.ALLOWED_CLAIMS);
            }
            if (rp.getScopes().contains("address")) {
                claims.removeAll(OidcAddressScopeAttributeReleasePolicy.ALLOWED_CLAIMS);
            }
            if (rp.getScopes().contains("email")) {
                claims.removeAll(OidcEmailScopeAttributeReleasePolicy.ALLOWED_CLAIMS);
            }
            if (rp.getScopes().contains("phone")) {
                claims.removeAll(OidcPhoneScopeAttributeReleasePolicy.ALLOWED_CLAIMS);
            }
            return claims.stream();
        }).collect(Collectors.toSet());
        if (!customClaims.isEmpty()) {
            Stream.concat(new OidcDiscoveryProperties().getClaims().stream(), customClaims.stream()).collect(Collectors.joining(","));
            properties.put("cas.authn.oidc.discovery.claims", Stream.concat(new OidcDiscoveryProperties().getClaims().stream(), customClaims.stream()).collect(Collectors.joining(",")));
            properties.put("cas.authn.oidc.core.user-defined-scopes.syncope", customClaims.stream().collect(Collectors.joining(",")));
        }
        ((WAConfigService)syncopeClient.getService(WAConfigService.class)).list().forEach(attr -> properties.put(attr.getSchema(), attr.getValues().stream().collect(Collectors.joining(","))));
        LOG.debug("Collected WA properties: {}", properties);
        Map decodedProperties = this.configurationCipher.decode(properties, ArrayUtils.EMPTY_OBJECT_ARRAY);
        LOG.debug("Decoded WA properties: {}", (Object)decodedProperties);
        return new MapPropertySource(this.getClass().getName(), decodedProperties);
    }
}

