/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ImapSessionFolder;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.CopyCommand;
import com.icegreen.greenmail.imap.commands.IdRange;
import com.icegreen.greenmail.imap.commands.SelectedStateCommand;
import com.icegreen.greenmail.imap.commands.UidEnabledCommand;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailFolder;
import java.util.ArrayList;
import java.util.Iterator;

class MoveCommand
extends SelectedStateCommand
implements UidEnabledCommand {
    public static final String NAME = "MOVE";
    public static final String ARGS = "<sequence-set> <mailbox>";
    public static final String CAPABILITY = "MOVE";

    MoveCommand() {
        super("MOVE", ARGS);
    }

    @Override
    protected void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session) throws ProtocolException, FolderException {
        this.doProcess(request, response, session, false);
    }

    @Override
    public void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session, boolean useUids) throws ProtocolException, FolderException {
        MailFolder toFolder;
        IdRange[] idSet = this.parser.parseIdRange(request);
        String mailboxName = this.parser.mailbox(request);
        this.parser.endLine(request);
        ImapSessionFolder currentMailbox = session.getSelected();
        try {
            toFolder = this.getMailbox(mailboxName, session, true);
        }
        catch (FolderException e) {
            e.setResponseCode("TRYCREATE");
            throw e;
        }
        ArrayList<Long> uidsFilteredByIdSet = new ArrayList<Long>();
        currentMailbox.getMessages().forEach(storedMessage -> {
            long uid = storedMessage.getUid();
            try {
                if (useUids ? this.includes(idSet, uid) : this.includes(idSet, currentMailbox.getMsn(uid))) {
                    uidsFilteredByIdSet.add(uid);
                }
            }
            catch (FolderException e) {
                throw new IllegalStateException("Can not get msn for message in folder " + currentMailbox.getName() + " using uid +" + uid, e);
            }
        });
        ArrayList<Long> uidsAfterAction = new ArrayList<Long>();
        Iterator iterator = uidsFilteredByIdSet.iterator();
        while (iterator.hasNext()) {
            long uid = (Long)iterator.next();
            long copiedUid = currentMailbox.moveMessage(uid, toFolder);
            uidsAfterAction.add(copiedUid);
        }
        response.okResponse(CopyCommand.generateCopyUidResponseCode(toFolder, uidsFilteredByIdSet, uidsAfterAction), "");
        session.unsolicitedResponses(response);
        response.commandComplete(this);
    }
}

