/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.pac4j.authentication.handler.support;

import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.principal.ClientCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.provision.DelegatedClientUserProfileProvisioner;
import org.apereo.cas.integration.pac4j.authentication.handler.support.AbstractPac4jAuthenticationHandler;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.Clients;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatedClientAuthenticationHandler
extends AbstractPac4jAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedClientAuthenticationHandler.class);
    private final Clients clients;
    private final DelegatedClientUserProfileProvisioner profileProvisioner;

    public DelegatedClientAuthenticationHandler(String name, Integer order, ServicesManager servicesManager, PrincipalFactory principalFactory, Clients clients, DelegatedClientUserProfileProvisioner profileProvisioner, SessionStore sessionStore) {
        super(name, servicesManager, principalFactory, order, sessionStore);
        this.clients = clients;
        this.profileProvisioner = profileProvisioner;
    }

    public boolean supports(Credential credential) {
        return credential != null && ClientCredential.class.isAssignableFrom(credential.getClass());
    }

    protected AuthenticationHandlerExecutionResult doAuthentication(Credential credential, Service service) throws PreventedException {
        try {
            ClientCredential clientCredentials = (ClientCredential)credential;
            LOGGER.debug("Located client credentials as [{}]", (Object)clientCredentials);
            LOGGER.trace("Client name: [{}]", (Object)clientCredentials.getClientName());
            BaseClient client = this.clients.findClient(clientCredentials.getClientName()).map(BaseClient.class::cast).orElseThrow(() -> new IllegalArgumentException("Unable to determine client based on client name " + clientCredentials.getClientName()));
            LOGGER.trace("Delegated client is: [{}]", (Object)client);
            HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext();
            HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext();
            JEEContext webContext = new JEEContext(Objects.requireNonNull(request), Objects.requireNonNull(response));
            Optional userProfileResult = Optional.ofNullable(clientCredentials.getUserProfile());
            if (userProfileResult.isEmpty()) {
                Credentials credentials = clientCredentials.getCredentials();
                userProfileResult = client.getUserProfile(credentials, (WebContext)webContext, this.sessionStore);
            }
            UserProfile userProfile = userProfileResult.orElseThrow(() -> new PreventedException("Unable to fetch user profile from client " + client.getName()));
            LOGGER.debug("Final user profile is: [{}]", (Object)userProfile);
            userProfile.setClientName(clientCredentials.getClientName());
            this.storeUserProfile((WebContext)webContext, userProfile);
            return this.createResult(clientCredentials, userProfile, client);
        }
        catch (Exception e) {
            throw new PreventedException((Throwable)e);
        }
    }

    protected void preFinalizeAuthenticationHandlerResult(ClientCredential credentials, Principal principal, UserProfile profile, BaseClient client) {
        this.profileProvisioner.execute(principal, profile, client, (Credential)credentials);
    }
}

