/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationCredentialsThreadLocalBinder;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.token.device.InvalidOAuth20DeviceTokenException;
import org.apereo.cas.support.oauth.validator.token.device.ThrottledOAuth20DeviceUserCodeApprovalException;
import org.apereo.cas.support.oauth.validator.token.device.UnapprovedOAuth20DeviceUserCodeException;
import org.apereo.cas.support.oauth.web.endpoints.BaseOAuth20Controller;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGeneratedResult;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseResult;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.OAuth20UnauthorizedScopeRequestException;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.device.OAuth20DeviceToken;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.jooq.lambda.Unchecked;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.servlet.ModelAndView;

public class OAuth20AccessTokenEndpointController<T extends OAuth20ConfigurationContext>
extends BaseOAuth20Controller<T> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20AccessTokenEndpointController.class);
    private static final Map<String, AccessTokenExceptionResponses> ACCESS_TOKEN_RESPONSE_EXCEPTIONS = Map.of(InvalidOAuth20DeviceTokenException.class.getName(), new AccessTokenExceptionResponses("access_denied", "Could not identify and extract device token request for device token"), UnapprovedOAuth20DeviceUserCodeException.class.getName(), new AccessTokenExceptionResponses("authorization_pending", "User code is not yet approved for the device token request"), ThrottledOAuth20DeviceUserCodeApprovalException.class.getName(), new AccessTokenExceptionResponses("slow_down", "Device user code approval is too quick and is throttled. Requests must slow down"), OAuth20UnauthorizedScopeRequestException.class.getName(), new AccessTokenExceptionResponses("invalid_scope", "Invalid or unauthorized scope"));
    private final AuditableExecution accessTokenGrantAuditableRequestExtractor;

    public OAuth20AccessTokenEndpointController(T oauthConfigurationContext, AuditableExecution accessTokenGrantAuditableRequestExtractor) {
        super(oauthConfigurationContext);
        this.accessTokenGrantAuditableRequestExtractor = accessTokenGrantAuditableRequestExtractor;
    }

    private static ModelAndView handleAccessTokenException(Exception exception, HttpServletResponse response) {
        AccessTokenExceptionResponses data = ACCESS_TOKEN_RESPONSE_EXCEPTIONS.getOrDefault(exception.getClass().getName(), new AccessTokenExceptionResponses("invalid_grant", "Invalid or unauthorized grant"));
        LoggingUtils.error((Logger)LOGGER, (String)data.getMessage(), (Throwable)exception);
        return OAuth20Utils.writeError(response, data.getCode());
    }

    @PostMapping(path={"/oauth2.0/accessToken", "/oauth2.0/token"}, produces={"application/json"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JEEContext context = new JEEContext(request, response);
        try {
            if (!this.verifyAccessTokenRequest((WebContext)context)) {
                LoggingUtils.error((Logger)LOGGER, (String)"Access token validation failed");
                return OAuth20Utils.writeError(response, "invalid_grant");
            }
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return OAuth20Utils.writeError(response, "invalid_request");
        }
        try {
            AccessTokenRequestContext requestHolder = this.examineAndExtractAccessTokenGrantRequest(request, response);
            LoggingUtils.protocolMessage((String)"OAuth/OpenID Connect Token Request", Map.of("Token", Optional.ofNullable(requestHolder.getToken()).map(Ticket::getId).orElse("none"), "Device Code", StringUtils.defaultString((String)requestHolder.getDeviceCode()), "Scopes", String.join((CharSequence)",", requestHolder.getScopes()), "Registered Service", requestHolder.getRegisteredService().getName(), "Service", requestHolder.getService().getId(), "Principal", requestHolder.getAuthentication().getPrincipal().getId(), "Grant Type", requestHolder.getGrantType().getType(), "Response Type", requestHolder.getResponseType().getType()));
            LOGGER.debug("Creating access token for [{}]", (Object)requestHolder);
            AuthenticationCredentialsThreadLocalBinder.bindCurrent((Authentication)requestHolder.getAuthentication());
            OAuth20TokenGeneratedResult tokenResult = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getAccessTokenGenerator().generate(requestHolder);
            LOGGER.debug("Access token generated result is: [{}]", (Object)tokenResult);
            return this.generateAccessTokenResponse(requestHolder, tokenResult);
        }
        catch (Exception e) {
            return OAuth20AccessTokenEndpointController.handleAccessTokenException(e, response);
        }
    }

    @GetMapping(path={"/oauth2.0/accessToken", "/oauth2.0/token"})
    public ModelAndView handleGetRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.handleRequest(request, response);
    }

    protected ModelAndView generateAccessTokenResponse(AccessTokenRequestContext requestHolder, OAuth20TokenGeneratedResult result) {
        LOGGER.debug("Generating access token response for [{}]", (Object)result);
        long deviceRefreshInterval = Beans.newDuration((String)((OAuth20ConfigurationContext)this.getConfigurationContext()).getCasProperties().getAuthn().getOauth().getDeviceToken().getRefreshInterval()).getSeconds();
        ExpirationPolicyBuilder<OAuth20DeviceToken> dtPolicy = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getDeviceTokenExpirationPolicy();
        OAuth20AccessTokenResponseResult tokenResult = OAuth20AccessTokenResponseResult.builder().registeredService((RegisteredService)requestHolder.getRegisteredService()).service(requestHolder.getService()).accessTokenTimeout(result.getAccessToken().map(OAuth20AccessToken::getExpiresIn).orElse(0L).longValue()).deviceRefreshInterval(deviceRefreshInterval).deviceTokenTimeout(dtPolicy.buildTicketExpirationPolicy().getTimeToLive().longValue()).responseType(result.getResponseType().orElse(OAuth20ResponseTypes.NONE)).casProperties(((OAuth20ConfigurationContext)this.getConfigurationContext()).getCasProperties()).generatedToken(result).grantType(result.getGrantType().orElse(OAuth20GrantTypes.NONE)).userProfile(requestHolder.getUserProfile()).build();
        ModelAndView generatedTokenResult = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getAccessTokenResponseGenerator().generate(tokenResult);
        LinkedHashMap<String, HttpStatus> context = new LinkedHashMap<String, HttpStatus>(generatedTokenResult.getModel());
        if (generatedTokenResult.getStatus() != null) {
            context.put("status", generatedTokenResult.getStatus());
        }
        LoggingUtils.protocolMessage((String)"OAuth/OpenID Connect Token Response", context);
        return generatedTokenResult;
    }

    private AccessTokenRequestContext examineAndExtractAccessTokenGrantRequest(HttpServletRequest request, HttpServletResponse response) {
        AuditableContext audit = AuditableContext.builder().httpRequest((Object)request).httpResponse((Object)response).build();
        AuditableExecutionResult accessResult = this.accessTokenGrantAuditableRequestExtractor.execute(audit);
        Optional execResult = accessResult.getExecutionResult();
        return (AccessTokenRequestContext)execResult.orElseThrow(() -> new UnsupportedOperationException("Access token request is not supported"));
    }

    private boolean verifyAccessTokenRequest(WebContext context) throws Exception {
        List validators = (List)((OAuth20ConfigurationContext)this.getConfigurationContext()).getAccessTokenGrantRequestValidators().getObject();
        return validators.stream().filter(BeanSupplier::isNotProxy).filter(Unchecked.predicate(ext -> ext.supports(context))).findFirst().orElseThrow(() -> new UnsupportedOperationException("Access token request is not supported")).validate(context);
    }

    private static class AccessTokenExceptionResponses {
        private final String code;
        private final String message;

        @Generated
        public AccessTokenExceptionResponses(String code, String message) {
            this.code = code;
            this.message = message;
        }

        @Generated
        public String getCode() {
            return this.code;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }
    }
}

