/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.azure.ad.authentication;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.hjson.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class AzureActiveDirectoryAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureActiveDirectoryAuthenticationHandler.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().singleValueAsArray(true).build().toObjectMapper();
    private final String loginUrl;
    private final String resource;
    private final String clientId;

    public AzureActiveDirectoryAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Integer order, String clientId, String loginUrl, String resource) {
        super(name, servicesManager, principalFactory, order);
        this.clientId = clientId;
        this.loginUrl = loginUrl;
        this.resource = resource;
    }

    private String getUserInfoFromGraph(String accessToken) throws Exception {
        URL url = new URL(StringUtils.appendIfMissing((String)this.resource, (CharSequence)"/", (CharSequence[])new CharSequence[0]) + "v1.0/me");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Authorization", "Bearer " + accessToken);
        conn.setRequestProperty("Accept", "application/json");
        LOGGER.debug("Fetching user info from [{}] using access token [{}]", (Object)url.toExternalForm(), (Object)accessToken);
        int httpResponseCode = conn.getResponseCode();
        if (HttpStatus.valueOf((int)httpResponseCode).is2xxSuccessful()) {
            return IOUtils.toString((InputStream)conn.getInputStream(), (Charset)StandardCharsets.UTF_8);
        }
        String msg = String.format("Failed: status %s with message: %s", httpResponseCode, conn.getResponseMessage());
        throw new FailedLoginException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthenticationResult getAccessTokenFromUserCredentials(String username, String password) throws Exception {
        ExecutorService service = null;
        try {
            service = Executors.newFixedThreadPool(1);
            AuthenticationContext context = new AuthenticationContext(this.loginUrl, false, service);
            LOGGER.debug("Acquiring token for resource [{}] and client id [{}] for user [{}]", new Object[]{this.resource, this.clientId, username});
            Future future = context.acquireToken(this.resource, this.clientId, username, password, null);
            AuthenticationResult authenticationResult = (AuthenticationResult)future.get();
            return authenticationResult;
        }
        finally {
            if (service != null) {
                service.shutdown();
            }
        }
    }

    protected AuthenticationHandlerExecutionResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential, String originalPassword) throws GeneralSecurityException {
        try {
            String username = credential.getUsername();
            LOGGER.trace("Fetching token for [{}]", (Object)username);
            AuthenticationResult result = this.getAccessTokenFromUserCredentials(username, credential.toPassword());
            LOGGER.debug("Retrieved token [{}] for [{}]", (Object)result.getAccessToken(), (Object)username);
            String userInfo = this.getUserInfoFromGraph(result.getAccessToken());
            LOGGER.trace("Retrieved user info [{}]", (Object)userInfo);
            Map userInfoMap = (Map)MAPPER.readValue(JsonValue.readHjson((String)userInfo).toString(), Map.class);
            HashMap attributeMap = Maps.newHashMapWithExpectedSize((int)userInfoMap.size());
            userInfoMap.forEach((key, value) -> {
                ArrayList values = (ArrayList)CollectionUtils.toCollection((Object)value, ArrayList.class);
                if (!values.isEmpty()) {
                    attributeMap.put(key, values);
                }
            });
            Principal principal = this.principalFactory.createPrincipal(username, (Map)attributeMap);
            LOGGER.debug("Created principal for id [{}] and [{}] attributes", (Object)username, (Object)attributeMap);
            return this.createHandlerResult((Credential)credential, principal, new ArrayList(0));
        }
        catch (Exception e) {
            throw new FailedLoginException("Invalid credentials: " + e.getMessage());
        }
    }
}

