/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.server.impl;

import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.server.ConnectorServer;
import org.identityconnectors.framework.server.impl.CCLWatchThread;
import org.identityconnectors.framework.server.impl.CCLWatchThreadFactory;
import org.identityconnectors.framework.server.impl.ConnectionProcessor;

class ConnectionListener
extends CCLWatchThread {
    private static final int INTERNAL_QUEUE_SIZE = 2;
    private static final Log LOG = Log.getLog(ConnectionListener.class);
    private final ConnectorServer connectorServer;
    private final ServerSocket socket;
    private final ExecutorService threadPool;
    private boolean stopped = false;

    public ConnectionListener(ConnectorServer server, ServerSocket socket) {
        super("ConnectionListener");
        this.connectorServer = server;
        this.socket = socket;
        this.threadPool = new ThreadPoolExecutor(server.getMinWorkers(), server.getMaxWorkers(), 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(2, true), new CCLWatchThreadFactory());
        LOG.ok("Initialized instance of Connection listener with min amount of worker threads: {0} ,and max worker threads: {1}", new Object[]{server.getMinWorkers(), server.getMaxWorkers()});
    }

    @Override
    public void run() {
        block8: while (!this.isStopped()) {
            try {
                Socket connection = this.socket.accept();
                ConnectionProcessor processor = new ConnectionProcessor(this.connectorServer, connection);
                while (true) {
                    try {
                        this.threadPool.execute(processor);
                        continue block8;
                    }
                    catch (RejectedExecutionException e) {
                        LOG.warn((Throwable)e, "Execution exception occurred during Connector Server connection runtime: {0}", new Object[]{e.getLocalizedMessage()});
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception e2) {
                            LOG.warn((Throwable)e, "Handled exception occurred during Connector Server connection runtime: {0}", new Object[]{e2.getLocalizedMessage()});
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable e) {
                if (!this.isStopped() || !(e instanceof SocketException)) {
                    LOG.error(e, "Error processing request: {0}", new Object[]{e.getLocalizedMessage()});
                }
                if (this.isStopped()) continue;
                try {
                    LOG.ok("Retry of connection execution.", new Object[0]);
                    Thread.sleep(1000L);
                }
                catch (Exception e2) {
                    LOG.warn(e, "Handled exception occurred during Connector Server connection runtime: {0}", new Object[]{e2.getLocalizedMessage()});
                }
            }
        }
    }

    private synchronized void markStopped() {
        this.stopped = true;
    }

    private synchronized boolean isStopped() {
        return this.stopped;
    }

    public void shutdown() {
        if (Thread.currentThread() == this) {
            throw new IllegalArgumentException("Shutdown may not be called from this thread");
        }
        if (!this.isStopped()) {
            try {
                this.markStopped();
                LOG.info("About do close the Connector Server connection socket.", new Object[0]);
                this.socket.close();
                this.join();
                LOG.info("Shutting down Connector Server connection thread pool.", new Object[0]);
                this.threadPool.shutdown();
                LOG.info("Connector Server connection shutdown complete", new Object[0]);
            }
            catch (Exception e) {
                throw ConnectorException.wrap((Throwable)e);
            }
        }
    }
}

