/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.framework.common.exceptions.ConfigurationException;
import org.identityconnectors.framework.impl.api.local.BundleKey;
import org.identityconnectors.framework.impl.api.local.ConnectorBundleManifest;

public class WorkingBundleInfo {
    private String originalLocation;
    private ConnectorBundleManifest bundleManifest;
    private Set<String> immediateBundleContents = new HashSet<String>();
    private List<URL> immediateClassPath = new ArrayList<URL>();
    private Map<String, String> immediateNativeLibraries = new HashMap<String, String>();
    private List<WorkingBundleInfo> embeddedBundles = new ArrayList<WorkingBundleInfo>();
    private List<URL> effectiveClassPath;
    private Map<String, String> effectiveNativeLibraries;
    private Set<String> effectiveContents;
    private static final String FORMAT = "There is more than one bundle with the same name+version: %s";

    public WorkingBundleInfo(String originalLocation) {
        this.originalLocation = originalLocation;
    }

    public String getOriginalLocation() {
        return this.originalLocation;
    }

    public ConnectorBundleManifest getManifest() {
        return this.bundleManifest;
    }

    public void setManifest(ConnectorBundleManifest manifest) {
        this.bundleManifest = manifest;
    }

    public Set<String> getImmediateBundleContents() {
        return this.immediateBundleContents;
    }

    public List<URL> getImmediateClassPath() {
        return this.immediateClassPath;
    }

    public Map<String, String> getImmediateNativeLibraries() {
        return this.immediateNativeLibraries;
    }

    public List<WorkingBundleInfo> getEmbeddedBundles() {
        return this.embeddedBundles;
    }

    public List<URL> getEffectiveClassPath() {
        return this.effectiveClassPath;
    }

    public Map<String, String> getEffectiveNativeLibraries() {
        return this.effectiveNativeLibraries;
    }

    public Set<String> getEffectiveContents() {
        return this.effectiveContents;
    }

    public static void resolve(List<? extends WorkingBundleInfo> infos) throws ConfigurationException {
        for (WorkingBundleInfo workingBundleInfo : infos) {
            workingBundleInfo.effectiveClassPath = null;
            workingBundleInfo.effectiveContents = null;
        }
        WorkingBundleInfo.ensureBundlesAreUnique(infos);
        WorkingBundleInfo.resolveEffectiveProperties(infos);
    }

    private static void ensureBundlesAreUnique(List<? extends WorkingBundleInfo> working) throws ConfigurationException {
        HashSet<BundleKey> bundleKeys = new HashSet<BundleKey>();
        for (WorkingBundleInfo workingBundleInfo : working) {
            BundleKey key = new BundleKey(workingBundleInfo.bundleManifest.getBundleName(), workingBundleInfo.bundleManifest.getBundleVersion());
            if (bundleKeys.contains((Object)key)) {
                throw new ConfigurationException(String.format(FORMAT, new Object[]{key}));
            }
            bundleKeys.add(key);
        }
    }

    private static void resolveEffectiveProperties(List<? extends WorkingBundleInfo> infos) throws ConfigurationException {
        for (WorkingBundleInfo workingBundleInfo : infos) {
            ArrayList<URL> classPath = new ArrayList<URL>();
            LinkedHashMap<String, String> nativeLibraries = new LinkedHashMap<String, String>();
            HashSet<String> contents = new HashSet<String>();
            classPath.addAll(workingBundleInfo.getImmediateClassPath());
            nativeLibraries.putAll(workingBundleInfo.getImmediateNativeLibraries());
            contents.addAll(workingBundleInfo.getImmediateBundleContents());
            WorkingBundleInfo.resolveEffectiveProperties(workingBundleInfo.getEmbeddedBundles());
            for (WorkingBundleInfo embedded : workingBundleInfo.getEmbeddedBundles()) {
                classPath.addAll(embedded.getEffectiveClassPath());
                for (Map.Entry<String, String> entry : embedded.getEffectiveNativeLibraries().entrySet()) {
                    if (nativeLibraries.containsKey(entry.getKey())) continue;
                    nativeLibraries.put(entry.getKey(), entry.getValue());
                }
                contents.addAll(embedded.getEffectiveContents());
            }
            workingBundleInfo.effectiveClassPath = classPath;
            workingBundleInfo.effectiveNativeLibraries = nativeLibraries;
            workingBundleInfo.effectiveContents = contents;
        }
    }
}

