/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.editor;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.editor.SummernoteConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.editor.SummernoteEditorCssReference;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.editor.SummernoteEditorFormDataReference;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.editor.SummernoteEditorJavaScriptReference;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.editor.SummernoteEditorOverlayCssReference;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.editor.SummernoteStorage;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome5CssReference;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.references.SpinJsReference;
import java.io.Closeable;
import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.util.string.JavaScriptUtils;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.protocol.http.servlet.MultipartServletWebRequest;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.template.PackageTextTemplate;

public class SummernoteEditor
extends FormComponent<String> {
    private static final long serialVersionUID = 1L;
    private static final Pattern NEW_LINE_PATTERN = Pattern.compile("(\\r\\n|\\n|\\r)");
    private final SummernoteConfig config;
    private final SummernoteEditorImageAjaxEventBehavior summernoteEditorImageAjaxEventBehavior;

    public SummernoteEditor(String id) {
        this(id, null, new SummernoteConfig());
    }

    public SummernoteEditor(String id, IModel<String> model) {
        this(id, model, new SummernoteConfig());
    }

    public SummernoteEditor(String id, IModel<String> model, SummernoteConfig config) {
        super(id, model);
        this.setOutputMarkupId(true);
        this.config = (SummernoteConfig)((Object)Args.notNull((Object)((Object)config), (String)"config"));
        if (config.isAirMode()) {
            this.setEscapeModelStrings(false);
        }
        Behavior[] behaviorArray = new Behavior[1];
        this.summernoteEditorImageAjaxEventBehavior = new SummernoteEditorImageAjaxEventBehavior();
        behaviorArray[0] = this.summernoteEditorImageAjaxEventBehavior;
        this.add(behaviorArray);
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (this.config.isAirMode()) {
            tag.setName("div");
        }
    }

    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        super.onComponentTagBody(markupStream, openTag);
        if (this.config.isAirMode()) {
            this.replaceComponentTagBody(markupStream, openTag, (CharSequence)this.getModelObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderHead(IHeaderResponse response) {
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)SummernoteEditorCssReference.instance()));
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)FontAwesome5CssReference.instance()));
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)SummernoteEditorOverlayCssReference.instance()));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)SummernoteEditorJavaScriptReference.instance()));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)SummernoteEditorFormDataReference.instance()));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)SpinJsReference.INSTANCE));
        PackageTextTemplate summernoteTemplate = null;
        try {
            summernoteTemplate = new PackageTextTemplate(SummernoteEditor.class, "js/summernote_init.js");
            this.config.withImageUploadCallbackUrl(this.summernoteEditorImageAjaxEventBehavior.getCallbackUrl().toString());
            this.config.put(SummernoteConfig.Id, this.getMarkupId());
            if (this.config.getStorageId() == null) {
                this.config.getButtons("Insert").remove("picture");
            }
            String jsonConfig = this.config.toJsonString();
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("summernoteconfig", jsonConfig);
            String summernoteTemplateJavaScript = summernoteTemplate.asString(variables);
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)summernoteTemplateJavaScript));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(summernoteTemplate);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)summernoteTemplate);
        String modelObject = (String)this.getModelObject();
        if (!this.config.isAirMode() && !Strings.isEmpty((CharSequence)modelObject)) {
            modelObject = NEW_LINE_PATTERN.matcher(modelObject).replaceAll("<br/>");
            CharSequence safeModelObject = JavaScriptUtils.escapeQuotes((CharSequence)modelObject);
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)String.format("$('#%s').summernote('code', '%s')", this.getMarkupId(), safeModelObject)));
        }
    }

    protected void onImageUpload(AjaxRequestTarget target, Map<String, FileItem> fileItemsMap) {
    }

    protected void onImageError(AjaxRequestTarget target, FileUploadException fux) {
    }

    private class SummernoteEditorImageAjaxEventBehavior
    extends AbstractDefaultAjaxBehavior {
        private static final long serialVersionUID = 1L;

        private SummernoteEditorImageAjaxEventBehavior() {
        }

        protected void respond(AjaxRequestTarget target) {
            try {
                ServletWebRequest webRequest = (ServletWebRequest)SummernoteEditor.this.getRequest();
                MultipartServletWebRequest multiPartRequest = webRequest.newMultipartWebRequest(Bytes.megabytes((long)SummernoteEditor.this.config.getMaxFileSize()), "ignored");
                multiPartRequest.parseFileParts();
                Map<String, FileItem> fileItemsMap = this.storeFile(target, multiPartRequest);
                SummernoteEditor.this.onImageUpload(target, fileItemsMap);
            }
            catch (FileUploadException fux) {
                SummernoteEditor.this.onImageError(target, fux);
            }
        }

        private Map<String, FileItem> storeFile(AjaxRequestTarget target, MultipartServletWebRequest multiPartRequest) {
            LinkedHashMap<String, FileItem> fileItemsMap = new LinkedHashMap<String, FileItem>();
            Map fileMap = multiPartRequest.getFiles();
            Iterator fileItemListIterator = fileMap.values().iterator();
            while (fileItemListIterator.hasNext()) {
                for (FileItem fileItem : (List)fileItemListIterator.next()) {
                    String imageName = SummernoteEditor.this.config.getImageNamePrefix() + fileItem.getName();
                    try {
                        SummernoteStorage storage = SummernoteConfig.getStorage(SummernoteEditor.this.config.getStorageId());
                        storage.writeContent(imageName, fileItem.getInputStream());
                        WebResponse response = (WebResponse)target.getHeaderResponse().getResponse();
                        response.setHeader("imageUrl", "/summernoteimages?image=" + Base64.getEncoder().encodeToString(imageName.getBytes()));
                        fileItemsMap.put(imageName, fileItem);
                    }
                    catch (IOException e) {
                        throw new WicketRuntimeException("Error while writing image: " + imageName, (Throwable)e);
                    }
                }
            }
            return fileItemsMap;
        }

        protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
            super.updateAjaxAttributes(attributes);
            attributes.setMultipart(true);
        }
    }
}

