/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.datatable.button;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import com.googlecode.wicket.kendo.ui.datatable.button.CommandButton;
import org.apache.wicket.ajax.attributes.CallbackParameter;

public class CommandAjaxBehavior
extends JQueryAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private final CommandButton button;

    public CommandAjaxBehavior(IJQueryAjaxAware source, CommandButton button) {
        super(source);
        this.button = button;
    }

    public CommandButton getButton() {
        return this.button;
    }

    protected CallbackParameter[] getCallbackParameters() {
        return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"data", (String)"kendo.stringify(this.dataItem($tr))"), CallbackParameter.resolved((String)"value", (String)String.format("this.dataItem($tr).%s", this.button.getProperty()))};
    }

    public CharSequence getCallbackFunctionBody(CallbackParameter ... parameters) {
        StringBuilder builder = new StringBuilder();
        builder.append("e.preventDefault();\n");
        builder.append("var $tr = jQuery(e.target).closest('tr');\n");
        builder.append(super.getCallbackFunctionBody(parameters));
        return builder.toString();
    }

    protected JQueryEvent newEvent() {
        return new CommandClickEvent(this.button);
    }

    public static class CommandClickEvent
    extends JQueryEvent {
        private final CommandButton button;
        private final String value;

        public CommandClickEvent(CommandButton button) {
            this.button = button;
            this.value = RequestCycleUtils.getQueryParameterValue((String)"value").toString();
        }

        public CommandButton getButton() {
            return this.button;
        }

        public String getValue() {
            return this.value;
        }
    }
}

