/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Collection;
import java.util.Objects;
import org.apache.sis.filter.BinaryGeometryFilter;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.LeafExpression;
import org.apache.sis.geometry.WraparoundMethod;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryWrapper;
import org.apache.sis.geometry.wrapper.SpatialOperationContext;
import org.apache.sis.pending.geoapi.filter.SpatialOperatorName;
import org.apache.sis.util.Exceptions;
import org.opengis.geometry.Envelope;

final class BinarySpatialFilter<R>
extends BinaryGeometryFilter<R> {
    private static final long serialVersionUID = -7600403345673820881L;
    private final SpatialOperatorName operatorType;

    BinarySpatialFilter(Geometries<?> library, Expression<R, ?> geometry, Envelope bounds, WraparoundMethod wraparound) {
        super(library, geometry, new LeafExpression.Transformed(library.toGeometry2D(bounds, wraparound), new LeafExpression.Literal(bounds)), null);
        this.operatorType = SpatialOperatorName.BBOX;
    }

    BinarySpatialFilter(SpatialOperatorName operatorType, Geometries<?> library, Expression<R, ?> geometry1, Expression<R, ?> geometry2) {
        super(library, geometry1, geometry2, null);
        this.operatorType = Objects.requireNonNull(operatorType);
    }

    @Override
    protected BinaryGeometryFilter<R> recreate(Expression<R, ?> geometry1, Expression<R, ?> geometry2) {
        return new BinarySpatialFilter<R>(this.operatorType, BinarySpatialFilter.getGeometryLibrary(this.expression1), geometry1, geometry2);
    }

    public SpatialOperatorName getOperatorType() {
        return this.operatorType;
    }

    public Expression<R, ?> getOperand1() {
        return BinarySpatialFilter.original(this.expression1);
    }

    public Expression<R, ?> getOperand2() {
        return BinarySpatialFilter.original(this.expression2);
    }

    @Override
    protected Collection<?> getChildren() {
        return this.getExpressions();
    }

    @Override
    public boolean test(R object) {
        GeometryWrapper right;
        GeometryWrapper left = (GeometryWrapper)this.expression1.apply(object);
        if (left != null && (right = (GeometryWrapper)this.expression2.apply(object)) != null) {
            try {
                return left.predicate(this.operatorType, right, this.context);
            }
            catch (Exception e) {
                this.warning(Exceptions.unwrap((Exception)e), true);
            }
        }
        return this.emptyResult();
    }

    @Override
    protected boolean emptyResult() {
        return SpatialOperationContext.emptyResult(this.operatorType);
    }
}

