/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.attribute;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.rocketmq.common.attribute.Attribute;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class AttributeUtil {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqCommon");

    public static Map<String, String> alterCurrentAttributes(boolean create, Map<String, Attribute> all, ImmutableMap<String, String> currentAttributes, ImmutableMap<String, String> newAttributes) {
        HashMap<String, String> init = new HashMap<String, String>();
        HashMap<String, String> add = new HashMap<String, String>();
        HashMap<String, String> update = new HashMap<String, String>();
        HashMap<String, String> delete = new HashMap<String, String>();
        HashSet<String> keys = new HashSet<String>();
        for (Map.Entry attribute : newAttributes.entrySet()) {
            String key = (String)attribute.getKey();
            String realKey = AttributeUtil.realKey(key);
            String value = (String)attribute.getValue();
            AttributeUtil.validate(realKey);
            AttributeUtil.duplicationCheck(keys, realKey);
            if (create) {
                if (key.startsWith("+")) {
                    init.put(realKey, value);
                    continue;
                }
                throw new RuntimeException("only add attribute is supported while creating topic. key: " + realKey);
            }
            if (key.startsWith("+")) {
                if (!currentAttributes.containsKey((Object)realKey)) {
                    add.put(realKey, value);
                    continue;
                }
                update.put(realKey, value);
                continue;
            }
            if (key.startsWith("-")) {
                if (!currentAttributes.containsKey((Object)realKey)) {
                    throw new RuntimeException("attempt to delete a nonexistent key: " + realKey);
                }
                delete.put(realKey, value);
                continue;
            }
            throw new RuntimeException("wrong format key: " + realKey);
        }
        AttributeUtil.validateAlter(all, init, true, false);
        AttributeUtil.validateAlter(all, add, false, false);
        AttributeUtil.validateAlter(all, update, false, false);
        AttributeUtil.validateAlter(all, delete, false, true);
        log.info("add: {}, update: {}, delete: {}", new Object[]{add, update, delete});
        HashMap<String, String> finalAttributes = new HashMap<String, String>((Map<String, String>)currentAttributes);
        finalAttributes.putAll(init);
        finalAttributes.putAll(add);
        finalAttributes.putAll(update);
        for (String s : delete.keySet()) {
            finalAttributes.remove(s);
        }
        return finalAttributes;
    }

    private static void duplicationCheck(Set<String> keys, String key) {
        boolean notExist = keys.add(key);
        if (!notExist) {
            throw new RuntimeException("alter duplication key. key: " + key);
        }
    }

    private static void validate(String kvAttribute) {
        if (Strings.isNullOrEmpty((String)kvAttribute)) {
            throw new RuntimeException("kv string format wrong.");
        }
        if (kvAttribute.contains("+")) {
            throw new RuntimeException("kv string format wrong.");
        }
        if (kvAttribute.contains("-")) {
            throw new RuntimeException("kv string format wrong.");
        }
    }

    private static void validateAlter(Map<String, Attribute> all, Map<String, String> alter, boolean init, boolean delete) {
        for (Map.Entry<String, String> entry : alter.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            Attribute attribute = all.get(key);
            if (attribute == null) {
                throw new RuntimeException("unsupported key: " + key);
            }
            if (!init && !attribute.isChangeable()) {
                throw new RuntimeException("attempt to update an unchangeable attribute. key: " + key);
            }
            if (delete) continue;
            attribute.verify(value);
        }
    }

    private static String realKey(String key) {
        return key.substring(1);
    }
}

