/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.auth.oauth2.protocol;

import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.impl.auth.oauth2.protocol.ClientCredentialsExchangeRequest;
import org.apache.pulsar.client.impl.auth.oauth2.protocol.ClientCredentialsExchanger;
import org.apache.pulsar.client.impl.auth.oauth2.protocol.TokenError;
import org.apache.pulsar.client.impl.auth.oauth2.protocol.TokenExchangeException;
import org.apache.pulsar.client.impl.auth.oauth2.protocol.TokenResult;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Response;

public class TokenClient
implements ClientCredentialsExchanger {
    private final URL tokenUrl;
    private final AsyncHttpClient httpClient;

    public TokenClient(URL tokenUrl, AsyncHttpClient httpClient) {
        this.httpClient = httpClient;
        this.tokenUrl = tokenUrl;
    }

    @Override
    public void close() throws Exception {
        this.httpClient.close();
    }

    String buildClientCredentialsBody(ClientCredentialsExchangeRequest req) {
        TreeMap<String, String> bodyMap = new TreeMap<String, String>();
        bodyMap.put("grant_type", "client_credentials");
        bodyMap.put("client_id", req.getClientId());
        bodyMap.put("client_secret", req.getClientSecret());
        if (!StringUtils.isBlank((CharSequence)req.getAudience())) {
            bodyMap.put("audience", req.getAudience());
        }
        if (!StringUtils.isBlank((CharSequence)req.getScope())) {
            bodyMap.put("scope", req.getScope());
        }
        return bodyMap.entrySet().stream().map(e -> URLEncoder.encode((String)e.getKey(), StandardCharsets.UTF_8) + "=" + URLEncoder.encode((String)e.getValue(), StandardCharsets.UTF_8)).collect(Collectors.joining("&"));
    }

    @Override
    public TokenResult exchangeClientCredentials(ClientCredentialsExchangeRequest req) throws TokenExchangeException, IOException {
        String body = this.buildClientCredentialsBody(req);
        try {
            Response res = (Response)((BoundRequestBuilder)((BoundRequestBuilder)((BoundRequestBuilder)this.httpClient.preparePost(this.tokenUrl.toString()).setHeader((CharSequence)"Accept", "application/json")).setHeader((CharSequence)"Content-Type", "application/x-www-form-urlencoded")).setBody(body)).execute().get();
            switch (res.getStatusCode()) {
                case 200: {
                    return (TokenResult)ObjectMapperFactory.getMapper().reader().readValue(res.getResponseBodyAsBytes(), TokenResult.class);
                }
                case 400: 
                case 401: {
                    throw new TokenExchangeException((TokenError)ObjectMapperFactory.getMapper().reader().readValue(res.getResponseBodyAsBytes(), TokenError.class));
                }
            }
            throw new IOException("Failed to perform HTTP request. res: " + res.getStatusCode() + " " + res.getStatusText());
        }
        catch (InterruptedException | ExecutionException e1) {
            if (e1 instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new IOException(e1);
        }
    }
}

