/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollMode;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.incubator.channel.uring.IOUring;
import io.netty.incubator.channel.uring.IOUringDatagramChannel;
import io.netty.incubator.channel.uring.IOUringEventLoopGroup;
import io.netty.incubator.channel.uring.IOUringServerSocketChannel;
import io.netty.incubator.channel.uring.IOUringSocketChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadFactory;
import lombok.Generated;
import org.apache.bookkeeper.common.util.affinity.CpuAffinity;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.common.util.netty.NettyFutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventLoopUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventLoopUtil.class);
    private static final String ENABLE_IO_URING = "pulsar.enableUring";

    public static EventLoopGroup newEventLoopGroup(int nThreads, boolean enableBusyWait, ThreadFactory threadFactory) {
        if (Epoll.isAvailable()) {
            if (EventLoopUtil.isIoUringEnabledAndAvailable()) {
                return new IOUringEventLoopGroup(nThreads, threadFactory);
            }
            if (!enableBusyWait) {
                return new EpollEventLoopGroup(nThreads, threadFactory);
            }
            EpollEventLoopGroup eventLoopGroup = new EpollEventLoopGroup(nThreads, threadFactory, () -> (selectSupplier, hasTasks) -> -3);
            for (int i = 0; i < nThreads; ++i) {
                eventLoopGroup.next().submit(() -> {
                    try {
                        CpuAffinity.acquireCore();
                    }
                    catch (Throwable t) {
                        log.warn("Failed to acquire CPU core for thread {} {}", new Object[]{Thread.currentThread().getName(), t.getMessage(), t});
                    }
                });
            }
            return eventLoopGroup;
        }
        return new NioEventLoopGroup(nThreads, threadFactory);
    }

    private static boolean isIoUringEnabledAndAvailable() {
        boolean ioUringEnabled = StringUtils.equalsAnyIgnoreCase((CharSequence)System.getProperty(ENABLE_IO_URING), (CharSequence[])new CharSequence[]{"1", "true"});
        if (ioUringEnabled) {
            IOUring.ensureAvailability();
        }
        return ioUringEnabled;
    }

    public static Class<? extends SocketChannel> getClientSocketChannelClass(EventLoopGroup eventLoopGroup) {
        if (eventLoopGroup instanceof IOUringEventLoopGroup) {
            return IOUringSocketChannel.class;
        }
        if (eventLoopGroup instanceof EpollEventLoopGroup) {
            return EpollSocketChannel.class;
        }
        return NioSocketChannel.class;
    }

    public static Class<? extends SocketChannel> getClientSocketChannelClass() {
        if (Epoll.isAvailable()) {
            if (EventLoopUtil.isIoUringEnabledAndAvailable()) {
                return IOUringSocketChannel.class;
            }
            return EpollSocketChannel.class;
        }
        return NioSocketChannel.class;
    }

    public static Class<? extends ServerSocketChannel> getServerSocketChannelClass(EventLoopGroup eventLoopGroup) {
        if (eventLoopGroup instanceof IOUringEventLoopGroup) {
            return IOUringServerSocketChannel.class;
        }
        if (eventLoopGroup instanceof EpollEventLoopGroup) {
            return EpollServerSocketChannel.class;
        }
        return NioServerSocketChannel.class;
    }

    public static Class<? extends ServerSocketChannel> getServerSocketChannelClass() {
        if (Epoll.isAvailable()) {
            if (EventLoopUtil.isIoUringEnabledAndAvailable()) {
                return IOUringServerSocketChannel.class;
            }
            return EpollServerSocketChannel.class;
        }
        return NioServerSocketChannel.class;
    }

    public static Class<? extends DatagramChannel> getDatagramChannelClass(EventLoopGroup eventLoopGroup) {
        if (eventLoopGroup instanceof IOUringEventLoopGroup) {
            return IOUringDatagramChannel.class;
        }
        if (eventLoopGroup instanceof EpollEventLoopGroup) {
            return EpollDatagramChannel.class;
        }
        return NioDatagramChannel.class;
    }

    public static Class<? extends DatagramChannel> getDatagramChannelClass() {
        if (Epoll.isAvailable()) {
            if (EventLoopUtil.isIoUringEnabledAndAvailable()) {
                return IOUringDatagramChannel.class;
            }
            return EpollDatagramChannel.class;
        }
        return NioDatagramChannel.class;
    }

    public static void enableTriggeredMode(ServerBootstrap bootstrap) {
        if (Epoll.isAvailable()) {
            bootstrap.childOption(EpollChannelOption.EPOLL_MODE, (Object)EpollMode.LEVEL_TRIGGERED);
        }
    }

    public static CompletableFuture<Void> shutdownGracefully(EventLoopGroup eventLoopGroup) {
        return NettyFutureUtil.toCompletableFutureVoid(eventLoopGroup.shutdownGracefully());
    }
}

