/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.ThreadLocalRandom;
import kafka.controller.StateChangeLogger;
import kafka.server.CachedControllerId;
import kafka.server.KRaftCachedControllerId$;
import kafka.server.MetadataCache;
import kafka.server.metadata.ConfigRepository;
import kafka.utils.Logging;
import org.apache.kafka.admin.BrokerMetadata;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.DescribeClientQuotasRequestData;
import org.apache.kafka.common.message.DescribeClientQuotasResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.server.common.Features;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\rme\u0001\u0002\u001b6\u0001qB\u0001\"\u0015\u0001\u0003\u0006\u0004%\tA\u0015\u0005\t-\u0002\u0011\t\u0011)A\u0005'\")q\u000b\u0001C\u00011\"91\f\u0001a\u0001\n\u0013a\u0006b\u00025\u0001\u0001\u0004%I!\u001b\u0005\u0007_\u0002\u0001\u000b\u0015B/\t\u000fQ\u0004!\u0019!C\u0005k\"1A\u0010\u0001Q\u0001\nYDQ! \u0001\u0005\nyDq!!\u0012\u0001\t\u0003\t9\u0005C\u0004\u0002J\u0001!I!a\u0013\t\u000f\u0005E\u0006\u0001\"\u0003\u00024\"9\u0011q\u0019\u0001\u0005\n\u0005%\u0007bBAm\u0001\u0011%\u00111\u001c\u0005\b\u0003C\u0004A\u0011BAr\u0011\u001d\t9\u0010\u0001C!\u0003sD\u0011B!\b\u0001#\u0003%\tAa\b\t\u0013\tU\u0002!%A\u0005\u0002\t}\u0001b\u0002B\u001c\u0001\u0011\u0005#\u0011\b\u0005\b\u0005w\u0001A\u0011\tB\u001f\u0011\u001d\u0011I\u0005\u0001C!\u0005\u0017BqA!\u0016\u0001\t\u0003\u00129\u0006C\u0004\u0003`\u0001!\tE!\u0019\t\u000f\t\u0015\u0004\u0001\"\u0001\u0003h!9!1\u000e\u0001\u0005\u0002\t5\u0004b\u0002B9\u0001\u0011\u0005#1\u000f\u0005\b\u0005c\u0002A\u0011\u0002BD\u0011\u001d\u0011Y\t\u0001C!\u0005\u001bCqAa%\u0001\t\u0003\u0012)\nC\u0004\u0003\u001c\u0002!\tE!(\t\u000f\tU\u0006\u0001\"\u0011\u00038\"9!Q\u0018\u0001\u0005B\t}\u0006b\u0002Bd\u0001\u0011\u0005#\u0011\u001a\u0005\b\u0005\u001b\u0004A\u0011\tBh\u0011\u001d\u00119\u000e\u0001C!\u00053DqA!9\u0001\t\u0003\u0012\u0019\u000fC\u0004\u0003p\u0002!\tE!=\t\u000f\tm\b\u0001\"\u0011\u0003~\"9!q \u0001\u0005\n\r\u0005\u0001bBB\u0003\u0001\u0011\u00051q\u0001\u0005\b\u0007'\u0001A\u0011IB\u000b\u0011\u001d\u0019\u0019\u0003\u0001C\u0001\u0007KAqaa\n\u0001\t\u0003\u0019I\u0003C\u0004\u00040\u0001!\te!\r\t\u000f\r=\u0002\u0001\"\u0011\u00046!91\u0011\b\u0001\u0005\u0002\rm\u0002bBB!\u0001\u0011\u000531\t\u0005\b\u00073\u0002A\u0011AB.\u0011\u001d\u0019y\u0007\u0001C\u0001\u0007cBqa!!\u0001\t\u0003\u001a\u0019\tC\u0004\u0004\u0012\u0002!\tea%\u0003%-\u0013\u0016M\u001a;NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u0006\u0003m]\n\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0003qe\naa]3sm\u0016\u0014(\"\u0001\u001e\u0002\u000b-\fgm[1\u0004\u0001M)\u0001!P\"H\u001bB\u0011a(Q\u0007\u0002\u007f)\t\u0001)A\u0003tG\u0006d\u0017-\u0003\u0002C\u007f\t1\u0011I\\=SK\u001a\u0004\"\u0001R#\u000e\u0003]J!AR\u001c\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f!\tA5*D\u0001J\u0015\tQ\u0015(A\u0003vi&d7/\u0003\u0002M\u0013\n9Aj\\4hS:<\u0007C\u0001(P\u001b\u0005)\u0014B\u0001)6\u0005A\u0019uN\u001c4jOJ+\u0007o\\:ji>\u0014\u00180\u0001\u0005ce>\\WM]%e+\u0005\u0019\u0006C\u0001 U\u0013\t)vHA\u0002J]R\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\rqJg.\u001b;?)\tI&\f\u0005\u0002O\u0001!)\u0011k\u0001a\u0001'\u0006iqlY;se\u0016tG/S7bO\u0016,\u0012!\u0018\t\u0003=\u001al\u0011a\u0018\u0006\u0003A\u0006\fQ![7bO\u0016T!A\u000f2\u000b\u0005\r$\u0017AB1qC\u000eDWMC\u0001f\u0003\ry'oZ\u0005\u0003O~\u0013Q\"T3uC\u0012\fG/Y%nC\u001e,\u0017!E0dkJ\u0014XM\u001c;J[\u0006<Wm\u0018\u0013fcR\u0011!.\u001c\t\u0003}-L!\u0001\\ \u0003\tUs\u0017\u000e\u001e\u0005\b]\u0016\t\t\u00111\u0001^\u0003\rAH%M\u0001\u000f?\u000e,(O]3oi&k\u0017mZ3!Q\t1\u0011\u000f\u0005\u0002?e&\u00111o\u0010\u0002\tm>d\u0017\r^5mK\u0006\t2\u000f^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:\u0016\u0003Y\u0004\"a\u001e>\u000e\u0003aT!!_\u001d\u0002\u0015\r|g\u000e\u001e:pY2,'/\u0003\u0002|q\n\t2\u000b^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:\u0002%M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'\u000fI\u0001\u0019[\u0006L(-\u001a$jYR,'/\u00117jm\u0016\u0014V\r\u001d7jG\u0006\u001cH#C@\u0002\u001c\u0005u\u0011qEA\u001e!\u0019\t\t!a\u0003\u0002\u00105\u0011\u00111\u0001\u0006\u0005\u0003\u000b\t9!\u0001\u0003vi&d'BAA\u0005\u0003\u0011Q\u0017M^1\n\t\u00055\u00111\u0001\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\u0011\t)\"a\u0002\u0002\t1\fgnZ\u0005\u0005\u00033\t\u0019BA\u0004J]R,w-\u001a:\t\u000b\u0001L\u0001\u0019A/\t\u000f\u0005}\u0011\u00021\u0001\u0002\"\u00059!M]8lKJ\u001c\b\u0003\u0002 \u0002$MK1!!\n@\u0005\u0015\t%O]1z\u0011\u001d\tI#\u0003a\u0001\u0003W\tA\u0002\\5ti\u0016tWM\u001d(b[\u0016\u0004B!!\f\u000285\u0011\u0011q\u0006\u0006\u0005\u0003c\t\u0019$A\u0004oKR<xN]6\u000b\u0007\u0005U\u0012-\u0001\u0004d_6lwN\\\u0005\u0005\u0003s\tyC\u0001\u0007MSN$XM\\3s\u001d\u0006lW\rC\u0004\u0002>%\u0001\r!a\u0010\u00025\u0019LG\u000e^3s+:\fg/Y5mC\ndW-\u00128ea>Lg\u000e^:\u0011\u0007y\n\t%C\u0002\u0002D}\u0012qAQ8pY\u0016\fg.\u0001\u0007dkJ\u0014XM\u001c;J[\u0006<W\rF\u0001^\u0003Q9W\r\u001e)beRLG/[8o\u001b\u0016$\u0018\rZ1uCRa\u0011QJAI\u0003'\u000b9+!+\u0002.B)a(a\u0014\u0002T%\u0019\u0011\u0011K \u0003\r=\u0003H/[8o!\u0019\t)&!\u001a\u0002l9!\u0011qKA1\u001d\u0011\tI&a\u0018\u000e\u0005\u0005m#bAA/w\u00051AH]8pizJ\u0011\u0001Q\u0005\u0004\u0003Gz\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003O\nIG\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\r\t\u0019g\u0010\t\u0005\u0003[\nYI\u0004\u0003\u0002p\u0005\u0015e\u0002BA9\u0003\u0003sA!a\u001d\u0002\u00009!\u0011QOA?\u001d\u0011\t9(a\u001f\u000f\t\u0005e\u0013\u0011P\u0005\u0002K&\u00111\rZ\u0005\u0003u\tL1!!\u000eb\u0013\u0011\t\u0019)a\r\u0002\u000f5,7o]1hK&!\u0011qQAE\u0003QiU\r^1eCR\f'+Z:q_:\u001cX\rR1uC*!\u00111QA\u001a\u0013\u0011\ti)a$\u000335+G/\u00193bi\u0006\u0014Vm\u001d9p]N,\u0007+\u0019:uSRLwN\u001c\u0006\u0005\u0003\u000f\u000bI\tC\u0003a\u0017\u0001\u0007Q\fC\u0004\u0002\u0016.\u0001\r!a&\u0002\u0013Q|\u0007/[2OC6,\u0007\u0003BAM\u0003CsA!a'\u0002\u001eB\u0019\u0011\u0011L \n\u0007\u0005}u(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003G\u000b)K\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003?{\u0004bBA\u0015\u0017\u0001\u0007\u00111\u0006\u0005\b\u0003W[\u0001\u0019AA \u0003e)'O]8s+:\fg/Y5mC\ndW-\u00128ea>Lg\u000e^:\t\u000f\u0005=6\u00021\u0001\u0002@\u0005IRM\u001d:peVs\u0017M^1jY\u0006\u0014G.\u001a'jgR,g.\u001a:t\u0003I9W\r^(gM2Lg.\u001a*fa2L7-Y:\u0015\u000f}\f),a.\u0002F\")\u0001\r\u0004a\u0001;\"9\u0011\u0011\u0018\u0007A\u0002\u0005m\u0016!\u00039beRLG/[8o!\u0011\ti,!1\u000e\u0005\u0005}&B\u0001\u001cb\u0013\u0011\t\u0019-a0\u0003+A\u000b'\u000f^5uS>t'+Z4jgR\u0014\u0018\r^5p]\"9\u0011\u0011\u0006\u0007A\u0002\u0005-\u0012\u0001E5t%\u0016\u0004H.[2b\u001f\u001a4G.\u001b8f)!\ty$a3\u0002N\u0006=\u0007bBA]\u001b\u0001\u0007\u00111\u0018\u0005\b\u0003Si\u0001\u0019AA\u0016\u0011\u001d\t\t.\u0004a\u0001\u0003'\faA\u0019:pW\u0016\u0014\b\u0003BA_\u0003+LA!a6\u0002@\n\u0011\"I]8lKJ\u0014VmZ5tiJ\fG/[8o\u0003UI7OU3qY&\u001c\u0017-\u00138PM\u001ad\u0017N\\3ESJ$b!a\u0010\u0002^\u0006}\u0007bBAi\u001d\u0001\u0007\u00111\u001b\u0005\b\u0003ss\u0001\u0019AA^\u0003A9W\r^!mSZ,WI\u001c3q_&tG\u000f\u0006\u0005\u0002f\u0006=\u0018\u0011_A{!\u0015q\u0014qJAt!\u0011\tI/a;\u000e\u0005\u0005M\u0012\u0002BAw\u0003g\u0011AAT8eK\")\u0001m\u0004a\u0001;\"1\u00111_\bA\u0002M\u000b!!\u001b3\t\u000f\u0005%r\u00021\u0001\u0002,\u0005\u0001r-\u001a;U_BL7-T3uC\u0012\fG/\u0019\u000b\u000b\u0003w\u0014iAa\u0006\u0003\u001a\tm\u0001CBA\u007f\u0005\u0007\u00119!\u0004\u0002\u0002\u0000*\u0019!\u0011A \u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\u0006\u0005}(aA*fcB!\u0011Q\u000eB\u0005\u0013\u0011\u0011Y!a$\u0003+5+G/\u00193bi\u0006\u0014Vm\u001d9p]N,Gk\u001c9jG\"9!q\u0002\tA\u0002\tE\u0011A\u0002;pa&\u001c7\u000f\u0005\u0004\u0002~\nM\u0011qS\u0005\u0005\u0005+\tyPA\u0002TKRDq!!\u000b\u0011\u0001\u0004\tY\u0003C\u0005\u0002,B\u0001\n\u00111\u0001\u0002@!I\u0011q\u0016\t\u0011\u0002\u0003\u0007\u0011qH\u0001\u001bO\u0016$Hk\u001c9jG6+G/\u00193bi\u0006$C-\u001a4bk2$HeM\u000b\u0003\u0005CQC!a\u0010\u0003$-\u0012!Q\u0005\t\u0005\u0005O\u0011\t$\u0004\u0002\u0003*)!!1\u0006B\u0017\u0003%)hn\u00195fG.,GMC\u0002\u00030}\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\u0019D!\u000b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u000ehKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uC\u0012\"WMZ1vYR$C'\u0001\u0007hKR\fE\u000e\u001c+pa&\u001c7\u000f\u0006\u0002\u0003\u0012\u0005\u0011r-\u001a;U_BL7\rU1si&$\u0018n\u001c8t)\u0011\u0011yDa\u0012\u0011\r\u0005u(1\u0003B!!\u0011\tIOa\u0011\n\t\t\u0015\u00131\u0007\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\t)\n\u0006a\u0001\u0003/\u000b!bZ3u)>\u0004\u0018nY%e)\u0011\u0011iEa\u0015\u0011\t\u0005%(qJ\u0005\u0005\u0005#\n\u0019D\u0001\u0003Vk&$\u0007bBAK+\u0001\u0007\u0011qS\u0001\rO\u0016$Hk\u001c9jG:\u000bW.\u001a\u000b\u0005\u00053\u0012Y\u0006E\u0003?\u0003\u001f\n9\nC\u0004\u0003^Y\u0001\rA!\u0014\u0002\u000fQ|\u0007/[2JI\u0006q\u0001.Y:BY&4XM\u0011:pW\u0016\u0014H\u0003BA \u0005GBQ!U\fA\u0002M\u000ba\"[:Ce>\\WM\u001d$f]\u000e,G\r\u0006\u0003\u0002@\t%\u0004\"B)\u0019\u0001\u0004\u0019\u0016\u0001F5t\u0005J|7.\u001a:TQV$H/\u001b8h\t><h\u000e\u0006\u0003\u0002@\t=\u0004\"B)\u001a\u0001\u0004\u0019\u0016aD4fi\u0006c\u0017N^3Ce>\\WM]:\u0015\u0005\tU\u0004CBA+\u0005o\u0012Y(\u0003\u0003\u0003z\u0005%$\u0001C%uKJ\f'\r\\3\u0011\t\tu$1Q\u0007\u0003\u0005\u007fR1A!!b\u0003\u0015\tG-\\5o\u0013\u0011\u0011)Ia \u0003\u001d\t\u0013xn[3s\u001b\u0016$\u0018\rZ1uCR!!Q\u000fBE\u0011\u0015\u00017\u00041\u0001^\u0003I9W\r^!mSZ,'I]8lKJtu\u000eZ3\u0015\r\u0005\u0015(q\u0012BI\u0011\u0015\tF\u00041\u0001T\u0011\u001d\tI\u0003\ba\u0001\u0003W\t1cZ3u\u00032Lg/\u001a\"s_.,'OT8eKN$BAa&\u0003\u001aB1\u0011Q B\u0002\u0003ODq!!\u000b\u001e\u0001\u0004\tY#\u0001\thKR\u0004\u0016M\u001d;ji&|g.\u00138g_R1!q\u0014BX\u0005c\u0003RAPA(\u0005C\u0003BAa)\u0003*:!\u0011q\u000eBS\u0013\u0011\u00119+!#\u00023U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti\u0012\u000bG/Y\u0005\u0005\u0005W\u0013iK\u0001\u000fVa\u0012\fG/Z'fi\u0006$\u0017\r^1QCJ$\u0018\u000e^5p]N#\u0018\r^3\u000b\t\t\u001d\u0016\u0011\u0012\u0005\b\u0003+s\u0002\u0019AAL\u0011\u0019\u0011\u0019L\ba\u0001'\u0006Y\u0001/\u0019:uSRLwN\\%e\u00035qW/\u001c)beRLG/[8ogR!!\u0011\u0018B^!\u0011q\u0014qJ*\t\u000f\u0005Uu\u00041\u0001\u0002\u0018\u0006yAo\u001c9jG:\u000bW.Z:U_&#7\u000f\u0006\u0002\u0003BBA\u0011\u0011\u0001Bb\u0003/\u0013i%\u0003\u0003\u0003F\u0006\r!aA'ba\u0006yAo\u001c9jG&#7\u000fV8OC6,7\u000f\u0006\u0002\u0003LBA\u0011\u0011\u0001Bb\u0005\u001b\n9*A\u0006u_BL7-\u00133J]\u001a|GC\u0001Bi!\u001dq$1\u001bBa\u0005\u0017L1A!6@\u0005\u0019!V\u000f\u001d7fe\u0005Qr-\u001a;QCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000b:$\u0007o\\5oiRA\u0011Q\u001dBn\u0005;\u0014y\u000eC\u0004\u0002\u0016\u000e\u0002\r!a&\t\r\tM6\u00051\u0001T\u0011\u001d\tIc\ta\u0001\u0003W\tAdZ3u!\u0006\u0014H/\u001b;j_:\u0014V\r\u001d7jG\u0006,e\u000e\u001a9pS:$8\u000f\u0006\u0004\u0003f\n%(Q\u001e\t\b\u0003{\u00149oUAt\u0013\u0011\u0011)-a@\t\u000f\t-H\u00051\u0001\u0003B\u0005\u0011A\u000f\u001d\u0005\b\u0003S!\u0003\u0019AA\u0016\u0003=9W\r^\"p]R\u0014x\u000e\u001c7fe&#WC\u0001Bz!\u0015q\u0014q\nB{!\r!%q_\u0005\u0004\u0005s<$AE\"bG\",GmQ8oiJ|G\u000e\\3s\u0013\u0012\facZ3u%\u0006tGm\\7BY&4XM\u0011:pW\u0016\u0014\u0018\nZ\u000b\u0003\u0005s\u000bAcZ3u%\u0006tGm\\7BY&4XM\u0011:pW\u0016\u0014H\u0003\u0002B]\u0007\u0007AQ\u0001Y\u0014A\u0002u\u000b1cZ3u\u00032Lg/\u001a\"s_.,'/\u00129pG\"$Ba!\u0003\u0004\u0012A)a(a\u0014\u0004\fA\u0019ah!\u0004\n\u0007\r=qH\u0001\u0003M_:<\u0007\"B))\u0001\u0004\u0019\u0016AE4fi\u000ecWo\u001d;fe6+G/\u00193bi\u0006$baa\u0006\u0004\u001e\r\u0005\u0002\u0003BAu\u00073IAaa\u0007\u00024\t91\t\\;ti\u0016\u0014\bbBB\u0010S\u0001\u0007\u0011qS\u0001\nG2,8\u000f^3s\u0013\u0012Dq!!\u000b*\u0001\u0004\tY#A\fti\u0006$Xm\u00115b]\u001e,GK]1dK\u0016s\u0017M\u00197fIR\u0011\u0011qH\u0001\u0014Y><7\u000b^1uK\u000eC\u0017M\\4f)J\f7-\u001a\u000b\u0004U\u000e-\u0002bBB\u0017W\u0001\u0007\u0011qS\u0001\u0004gR\u0014\u0018\u0001C2p]R\f\u0017N\\:\u0015\t\u0005}21\u0007\u0005\b\u0003+c\u0003\u0019AAL)\u0011\tyda\u000e\t\u000f\t-X\u00061\u0001\u0003B\u0005A1/\u001a;J[\u0006<W\rF\u0002k\u0007{Aaaa\u0010/\u0001\u0004i\u0016\u0001\u00038fo&k\u0017mZ3\u0002\r\r|gNZ5h)\u0011\u0019)ea\u0013\u0011\t\u0005\u00051qI\u0005\u0005\u0007\u0013\n\u0019A\u0001\u0006Qe>\u0004XM\u001d;jKNDqa!\u00140\u0001\u0004\u0019y%\u0001\bd_:4\u0017n\u001a*fg>,(oY3\u0011\t\rE3QK\u0007\u0003\u0007'RAa!\u0011\u00024%!1qKB*\u00059\u0019uN\u001c4jOJ+7o\\;sG\u0016\fA\u0003Z3tGJL'-Z\"mS\u0016tG/U;pi\u0006\u001cH\u0003BB/\u0007K\u0002Baa\u0018\u0004b5\u0011\u0011\u0011R\u0005\u0005\u0007G\nII\u0001\u0011EKN\u001c'/\u001b2f\u00072LWM\u001c;Rk>$\u0018m\u001d*fgB|gn]3ECR\f\u0007bBB4a\u0001\u00071\u0011N\u0001\be\u0016\fX/Z:u!\u0011\u0019yfa\u001b\n\t\r5\u0014\u0011\u0012\u0002 \t\u0016\u001c8M]5cK\u000ec\u0017.\u001a8u#V|G/Y:SKF,Xm\u001d;ECR\f\u0017\u0001\u00073fg\u000e\u0014\u0018NY3TGJ\fWn\u0011:fI\u0016tG/[1mgR!11OB=!\u0011\u0019yf!\u001e\n\t\r]\u0014\u0011\u0012\u0002)\t\u0016\u001c8M]5cKV\u001bXM]*de\u0006l7I]3eK:$\u0018.\u00197t%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0005\b\u0007O\n\u0004\u0019AB>!\u0011\u0019yf! \n\t\r}\u0014\u0011\u0012\u0002(\t\u0016\u001c8M]5cKV\u001bXM]*de\u0006l7I]3eK:$\u0018.\u00197t%\u0016\fX/Z:u\t\u0006$\u0018-A\bnKR\fG-\u0019;b-\u0016\u00148/[8o)\t\u0019)\t\u0005\u0003\u0004\b\u000e5UBABE\u0015\u0011\t)da#\u000b\u0005a\n\u0017\u0002BBH\u0007\u0013\u0013q\"T3uC\u0012\fG/\u0019,feNLwN\\\u0001\tM\u0016\fG/\u001e:fgR\u00111Q\u0013\t\u0005\u0007\u000f\u001b9*\u0003\u0003\u0004\u001a\u000e%%\u0001\u0003$fCR,(/Z:")
public class KRaftMetadataCache
implements MetadataCache,
Logging,
ConfigRepository {
    private final int brokerId;
    private volatile MetadataImage _currentImage;
    private final StateChangeLogger stateChangeLogger;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public Properties topicConfig(String topicName) {
        return ConfigRepository.topicConfig$(this, topicName);
    }

    @Override
    public Properties brokerConfig(int brokerId) {
        return ConfigRepository.brokerConfig$(this, brokerId);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    private MetadataImage _currentImage() {
        return this._currentImage;
    }

    private void _currentImage_$eq(MetadataImage x$1) {
        this._currentImage = x$1;
    }

    private StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private java.util.List<Integer> maybeFilterAliveReplicas(MetadataImage image, int[] brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        if (!filterUnavailableEndpoints) {
            return Replicas.toList((int[])brokers);
        }
        ArrayList<Integer> res = new ArrayList<Integer>(brokers.length);
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(brokers)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Option$.MODULE$.apply((Object)image.cluster().broker(brokerId)).foreach((Function1 & Serializable & scala.Serializable)b -> {
            if (!b.fenced() && b.listeners().containsKey(listenerName.value())) {
                return BoxesRunTime.boxToBoolean((boolean)res.add(Predef$.MODULE$.int2Integer(brokerId)));
            }
            return BoxedUnit.UNIT;
        }));
        return res;
    }

    public MetadataImage currentImage() {
        return this._currentImage();
    }

    private Option<Iterator<MetadataResponseData.MetadataResponsePartition>> getPartitionMetadata(MetadataImage image, String topicName, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            return new Some((Object)((GenSetLike)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(topic.partitions().entrySet()).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> {
                Integer partitionId = (Integer)entry.getKey();
                PartitionRegistration partition = (PartitionRegistration)entry.getValue();
                java.util.List<Integer> filteredReplicas = this.maybeFilterAliveReplicas(image, partition.replicas, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> filteredIsr = this.maybeFilterAliveReplicas(image, partition.isr, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> offlineReplicas = this.getOfflineReplicas(image, partition, listenerName);
                Option<Node> maybeLeader = this.getAliveEndpoint(image, partition.leader, listenerName);
                if (None$.MODULE$.equals(maybeLeader)) {
                    Errors errors;
                    if (!image.cluster().brokers().containsKey(BoxesRunTime.boxToInteger((int)partition.leader))) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": leader not available").toString());
                        errors = Errors.LEADER_NOT_AVAILABLE;
                    } else {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": listener ").append(listenerName).append(" ").append("not found on leader ").append(partition$1.leader).toString());
                        errors = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(Predef$.MODULE$.Integer2int(partitionId)).setLeaderId(-1).setLeaderEpoch(partition.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                if (maybeLeader instanceof Some) {
                    Errors errors;
                    Node leader = (Node)((Some)maybeLeader).value();
                    if (filteredReplicas.size() < partition.replicas.length) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(93).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": replica information not available for ").append("following brokers ").append(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partition$1.replicas)).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredReplicas.contains(x$1))))).mkString(",")).toString());
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else if (filteredIsr.size() < partition.isr.length) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": in sync replica information not available for ").append("following brokers ").append(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partition$1.isr)).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredIsr.contains(x$1))))).mkString(",")).toString());
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else {
                        errors = Errors.NONE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(Predef$.MODULE$.Integer2int(partitionId)).setLeaderId(leader.id()).setLeaderEpoch(partition.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                throw new MatchError(maybeLeader);
            }, scala.collection.mutable.Set$.MODULE$.canBuildFrom())).iterator());
        }
        throw new MatchError((Object)option);
    }

    private java.util.List<Integer> getOfflineReplicas(MetadataImage image, PartitionRegistration partition, ListenerName listenerName) {
        ArrayList<Integer> offlineReplicas = new ArrayList<Integer>(0);
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partition.replicas)).foreach((Function1 & Serializable & scala.Serializable)brokerId -> KRaftMetadataCache.$anonfun$getOfflineReplicas$1(this, image, offlineReplicas, partition, listenerName, BoxesRunTime.unboxToInt((Object)brokerId)));
        return offlineReplicas;
    }

    private boolean isReplicaOffline(PartitionRegistration partition, ListenerName listenerName, BrokerRegistration broker) {
        return broker.fenced() || !broker.listeners().containsKey(listenerName.value()) || this.isReplicaInOfflineDir(broker, partition);
    }

    private boolean isReplicaInOfflineDir(BrokerRegistration broker, PartitionRegistration partition) {
        return !broker.hasOnlineDir(partition.directory(broker.id()));
    }

    private Option<Node> getAliveEndpoint(MetadataImage image, int id, ListenerName listenerName) {
        return Option$.MODULE$.apply((Object)image.cluster().broker(id)).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$1.node(listenerName.value()))));
    }

    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataImage image = this._currentImage();
        return (Seq)topics.toSeq().flatMap((Function1 & Serializable & scala.Serializable)topic -> Option$.MODULE$.option2Iterable(this.getPartitionMetadata(image, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).map((Function1 & Serializable & scala.Serializable)partitionMetadata -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName(topic).setTopicId((Uuid)Option$.MODULE$.apply((Object)image.topics().getTopic(topic).id()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topic)).setPartitions((java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(partitionMetadata.toBuffer()).asJava()))), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public boolean getTopicMetadata$default$3() {
        return false;
    }

    @Override
    public boolean getTopicMetadata$default$4() {
        return false;
    }

    @Override
    public Set<String> getAllTopics() {
        return (Set)CollectionConverters$.MODULE$.asScalaSetConverter(this._currentImage().topics().topicsByName().keySet()).asScala();
    }

    @Override
    public Set<TopicPartition> getTopicPartitions(String topicName) {
        Option option = Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return Set$.MODULE$.empty();
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            return (Set)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(topic.partitions().keySet()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> new TopicPartition(topicName, Predef$.MODULE$.Integer2int(x$2)), scala.collection.mutable.Set$.MODULE$.canBuildFrom());
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Uuid getTopicId(String topicName) {
        return (Uuid)((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this._currentImage().topics().topicsByName()).asScala()).get((Object)topicName).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.id()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID);
    }

    @Override
    public Option<String> getTopicName(Uuid topicId) {
        return ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this._currentImage().topics().topicsById()).asScala()).get((Object)topicId).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.name());
    }

    @Override
    public boolean hasAliveBroker(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$hasAliveBroker$1(x$5))) == 1;
    }

    public boolean isBrokerFenced(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.fenced())) == 1;
    }

    public boolean isBrokerShuttingDown(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.inControlledShutdown())) == 1;
    }

    @Override
    public Iterable<BrokerMetadata> getAliveBrokers() {
        return this.getAliveBrokers(this._currentImage());
    }

    private Iterable<BrokerMetadata> getAliveBrokers(MetadataImage image) {
        return (Iterable)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(image.cluster().brokers().values()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.fenced()))).map((Function1 & Serializable & scala.Serializable)b -> new BrokerMetadata(b.id(), b.rack()), Iterable$.MODULE$.canBuildFrom());
    }

    @Override
    public Option<Node> getAliveBrokerNode(int brokerId, ListenerName listenerName) {
        return Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId)).filterNot((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.fenced())).flatMap((Function1 & Serializable & scala.Serializable)x$10 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$10.node(listenerName.value()))));
    }

    public Seq<Node> getAliveBrokerNodes(ListenerName listenerName) {
        return ((TraversableOnce)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this._currentImage().cluster().brokers().values()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.fenced()))).flatMap((Function1 & Serializable & scala.Serializable)x$12 -> Option$.MODULE$.option2Iterable(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$12.node(listenerName.value())))), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    @Override
    public Option<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfo(String topicName, int partitionId) {
        return Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName)).flatMap((Function1 & Serializable & scala.Serializable)topic -> Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger((int)partitionId)))).flatMap((Function1 & Serializable & scala.Serializable)partition -> new Some((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topicName).setPartitionIndex(partitionId).setControllerEpoch(-1).setLeader(partition.leader).setLeaderEpoch(partition.leaderEpoch).setIsr(Replicas.toList((int[])partition.isr)).setZkVersion(partition.partitionEpoch).setReplicas(Replicas.toList((int[])partition.replicas))));
    }

    @Override
    public Option<Object> numPartitions(String topicName) {
        return Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName)).map((Function1 & Serializable & scala.Serializable)topic -> BoxesRunTime.boxToInteger((int)KRaftMetadataCache.$anonfun$numPartitions$1(topic)));
    }

    @Override
    public java.util.Map<String, Uuid> topicNamesToIds() {
        return this._currentImage().topics().topicNameToIdView();
    }

    @Override
    public java.util.Map<Uuid, String> topicIdsToNames() {
        return this._currentImage().topics().topicIdToNameView();
    }

    @Override
    public Tuple2<java.util.Map<String, Uuid>, java.util.Map<Uuid, String>> topicIdInfo() {
        MetadataImage image = this._currentImage();
        return new Tuple2((Object)image.topics().topicNameToIdView(), (Object)image.topics().topicIdToNameView());
    }

    @Override
    public Option<Node> getPartitionLeaderEndpoint(String topicName, int partitionId, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            Option option2 = Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger((int)partitionId)));
            if (None$.MODULE$.equals(option2)) {
                return None$.MODULE$;
            }
            if (option2 instanceof Some) {
                PartitionRegistration partition = (PartitionRegistration)((Some)option2).value();
                Option option3 = Option$.MODULE$.apply((Object)image.cluster().broker(partition.leader));
                if (None$.MODULE$.equals(option3)) {
                    return new Some((Object)Node.noNode());
                }
                if (option3 instanceof Some) {
                    BrokerRegistration broker = (BrokerRegistration)((Some)option3).value();
                    return new Some((Object)broker.node(listenerName.value()).orElse(Node.noNode()));
                }
                throw new MatchError((Object)option3);
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Map<Object, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        scala.collection.mutable.HashMap result = new scala.collection.mutable.HashMap();
        Option$.MODULE$.apply((Object)image.topics().getTopic(tp.topic())).foreach((Function1 & Serializable & scala.Serializable)topic -> {
            KRaftMetadataCache.$anonfun$getPartitionReplicaEndpoints$1(image, listenerName, result, topic);
            return BoxedUnit.UNIT;
        });
        return result;
    }

    @Override
    public Option<CachedControllerId> getControllerId() {
        return this.getRandomAliveBroker(this._currentImage()).map((Function1)KRaftCachedControllerId$.MODULE$);
    }

    @Override
    public Option<Object> getRandomAliveBrokerId() {
        return this.getRandomAliveBroker(this._currentImage());
    }

    private Option<Object> getRandomAliveBroker(MetadataImage image) {
        List aliveBrokers = this.getAliveBrokers(image).toList();
        if (aliveBrokers.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)((BrokerMetadata)aliveBrokers.apply((int)ThreadLocalRandom.current().nextInt((int)aliveBrokers.size()))).id));
    }

    public Option<Object> getAliveBrokerEpoch(int brokerId) {
        return Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId)).filterNot((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.fenced())).map((Function1 & Serializable & scala.Serializable)brokerRegistration -> BoxesRunTime.boxToLong((long)brokerRegistration.epoch()));
    }

    @Override
    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        HashMap nodes = new HashMap();
        image.cluster().brokers().values().forEach(broker -> {
            if (!broker.fenced()) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(broker.node(listenerName.value()))).foreach((Function1 & Serializable & scala.Serializable)node -> nodes.put(Predef$.MODULE$.int2Integer(broker.id()), node));
                return;
            }
        });
        ArrayList partitionInfos = new ArrayList();
        HashSet internalTopics = new HashSet();
        image.topics().topicsByName().values().forEach(topic -> topic.partitions().entrySet().forEach(entry -> {
            Integer partitionId = (Integer)entry.getKey();
            PartitionRegistration partition = (PartitionRegistration)entry.getValue();
            partitionInfos.add(new PartitionInfo(topic.name(), Predef$.MODULE$.Integer2int(partitionId), KRaftMetadataCache.node$1(partition.leader, nodes), (Node[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partition.replicas)).map((Function1 & Serializable & scala.Serializable)replica -> KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)replica), nodes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Node.class))), (Node[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partition.isr)).map((Function1 & Serializable & scala.Serializable)replica -> KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)replica), nodes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Node.class))), (Node[])((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(this.getOfflineReplicas(image, partition, listenerName)).asScala()).map((Function1 & Serializable & scala.Serializable)replica -> KRaftMetadataCache.node$1(Predef$.MODULE$.Integer2int(replica), nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class))));
            if (Topic.isInternal((String)topic.name())) {
                internalTopics.add(topic.name());
                return;
            }
        }));
        Node controllerNode = KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)this.getRandomAliveBroker(image).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1)), nodes);
        return new Cluster(clusterId, nodes.values(), partitionInfos, Collections.emptySet(), internalTopics, controllerNode);
    }

    public boolean stateChangeTraceEnabled() {
        return this.stateChangeLogger().isTraceEnabled();
    }

    public void logStateChangeTrace(String str) {
        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> str);
    }

    @Override
    public boolean contains(String topicName) {
        return this._currentImage().topics().topicsByName().containsKey((Object)topicName);
    }

    @Override
    public boolean contains(TopicPartition tp) {
        Option option = Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(tp.topic()));
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            return ((TopicImage)((Some)option).value()).partitions().containsKey(BoxesRunTime.boxToInteger((int)tp.partition()));
        }
        throw new MatchError((Object)option);
    }

    public void setImage(MetadataImage newImage) {
        this._currentImage_$eq(newImage);
    }

    @Override
    public Properties config(ConfigResource configResource) {
        return this._currentImage().configs().configProperties(configResource);
    }

    public DescribeClientQuotasResponseData describeClientQuotas(DescribeClientQuotasRequestData request) {
        return this._currentImage().clientQuotas().describe(request);
    }

    public DescribeUserScramCredentialsResponseData describeScramCredentials(DescribeUserScramCredentialsRequestData request) {
        return this._currentImage().scram().describe(request);
    }

    @Override
    public MetadataVersion metadataVersion() {
        return this._currentImage().features().metadataVersion();
    }

    @Override
    public Features features() {
        MetadataImage image = this._currentImage();
        return new Features(image.features().metadataVersion(), image.features().finalizedVersions(), image.highestOffsetAndEpoch().offset(), true);
    }

    public static final /* synthetic */ Object $anonfun$getOfflineReplicas$1(KRaftMetadataCache $this, MetadataImage image$3, ArrayList offlineReplicas$1, PartitionRegistration partition$2, ListenerName listenerName$3, int brokerId) {
        Option option = Option$.MODULE$.apply((Object)image$3.cluster().broker(brokerId));
        if (None$.MODULE$.equals(option)) {
            return BoxesRunTime.boxToBoolean((boolean)offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId)));
        }
        if (option instanceof Some) {
            BrokerRegistration broker = (BrokerRegistration)((Some)option).value();
            if ($this.isReplicaOffline(partition$2, listenerName$3, broker)) {
                return BoxesRunTime.boxToBoolean((boolean)offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId)));
            }
            return BoxedUnit.UNIT;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$hasAliveBroker$1(BrokerRegistration x$5) {
        return !x$5.fenced();
    }

    public static final /* synthetic */ int $anonfun$numPartitions$1(TopicImage topic) {
        return topic.partitions().size();
    }

    public static final /* synthetic */ void $anonfun$getPartitionReplicaEndpoints$1(MetadataImage image$5, ListenerName listenerName$8, scala.collection.mutable.HashMap result$1, TopicImage topic) {
        topic.partitions().values().forEach(partition -> new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partition.replicas)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)replicaId -> {
            BrokerRegistration broker = image$5.cluster().broker(replicaId);
            if (broker != null && !broker.fenced()) {
                broker.node(listenerName$8.value()).ifPresent(node -> {
                    if (!node.isEmpty()) {
                        result$1.put((Object)BoxesRunTime.boxToInteger((int)replicaId), node);
                        return;
                    }
                });
                return;
            }
        }));
    }

    private static final Node node$1(int id, HashMap nodes$1) {
        return (Node)Option$.MODULE$.apply(nodes$1.get(BoxesRunTime.boxToInteger((int)id))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Node.noNode());
    }

    public KRaftMetadataCache(int brokerId) {
        this.brokerId = brokerId;
        Logging.$init$(this);
        ConfigRepository.$init$(this);
        this.logIdent_$eq(new StringBuilder(26).append("[MetadataCache brokerId=").append(brokerId).append("] ").toString());
        this._currentImage = MetadataImage.EMPTY;
        this.stateChangeLogger = new StateChangeLogger(brokerId, false, (Option<Object>)None$.MODULE$);
    }
}

