/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import org.apache.hadoop.thirdparty.protobuf.MessageOrBuilder;
import org.apache.hadoop.thirdparty.protobuf.TextFormat;
import org.apache.hadoop.yarn.api.records.QueueConfigurations;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

public class QueueConfigurationsPBImpl
extends QueueConfigurations {
    YarnProtos.QueueConfigurationsProto proto = YarnProtos.QueueConfigurationsProto.getDefaultInstance();
    YarnProtos.QueueConfigurationsProto.Builder builder = null;
    Resource configuredMinResource = null;
    Resource configuredMaxResource = null;
    Resource effMinResource = null;
    Resource effMaxResource = null;
    boolean viaProto = false;

    public QueueConfigurationsPBImpl() {
        this.builder = YarnProtos.QueueConfigurationsProto.newBuilder();
    }

    public QueueConfigurationsPBImpl(YarnProtos.QueueConfigurationsProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnProtos.QueueConfigurationsProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void mergeLocalToBuilder() {
        if (this.effMinResource != null) {
            this.builder.setEffectiveMinCapacity(this.convertToProtoFormat(this.effMinResource));
        }
        if (this.effMaxResource != null) {
            this.builder.setEffectiveMaxCapacity(this.convertToProtoFormat(this.effMaxResource));
        }
        if (this.configuredMinResource != null) {
            this.builder.setConfiguredMinCapacity(this.convertToProtoFormat(this.configuredMinResource));
        }
        if (this.configuredMaxResource != null) {
            this.builder.setConfiguredMaxCapacity(this.convertToProtoFormat(this.configuredMaxResource));
        }
    }

    public float getCapacity() {
        YarnProtos.QueueConfigurationsProto p = this.viaProto ? this.proto : this.builder;
        return p.hasCapacity() ? p.getCapacity() : 0.0f;
    }

    public void setCapacity(float capacity) {
        this.maybeInitBuilder();
        this.builder.setCapacity(capacity);
    }

    public float getAbsoluteCapacity() {
        YarnProtos.QueueConfigurationsProto p = this.viaProto ? this.proto : this.builder;
        return p.hasAbsoluteCapacity() ? p.getAbsoluteCapacity() : 0.0f;
    }

    public void setAbsoluteCapacity(float absoluteCapacity) {
        this.maybeInitBuilder();
        this.builder.setAbsoluteCapacity(absoluteCapacity);
    }

    public float getMaxCapacity() {
        YarnProtos.QueueConfigurationsProto p = this.viaProto ? this.proto : this.builder;
        return p.hasMaxCapacity() ? p.getMaxCapacity() : 0.0f;
    }

    public void setMaxCapacity(float maxCapacity) {
        this.maybeInitBuilder();
        this.builder.setMaxCapacity(maxCapacity);
    }

    public float getAbsoluteMaxCapacity() {
        YarnProtos.QueueConfigurationsProto p = this.viaProto ? this.proto : this.builder;
        return p.hasAbsoluteMaxCapacity() ? p.getAbsoluteMaxCapacity() : 0.0f;
    }

    public void setAbsoluteMaxCapacity(float absoluteMaxCapacity) {
        this.maybeInitBuilder();
        this.builder.setAbsoluteMaxCapacity(absoluteMaxCapacity);
    }

    public float getMaxAMPercentage() {
        YarnProtos.QueueConfigurationsProto p = this.viaProto ? this.proto : this.builder;
        return p.hasMaxAMPercentage() ? p.getMaxAMPercentage() : 0.0f;
    }

    public void setMaxAMPercentage(float maxAMPercentage) {
        this.maybeInitBuilder();
        this.builder.setMaxAMPercentage(maxAMPercentage);
    }

    public Resource getEffectiveMinCapacity() {
        YarnProtos.QueueConfigurationsProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.effMinResource != null) {
            return this.effMinResource;
        }
        if (!p.hasEffectiveMinCapacity()) {
            return null;
        }
        this.effMinResource = this.convertFromProtoFormat(p.getEffectiveMinCapacity());
        return this.effMinResource;
    }

    public void setEffectiveMinCapacity(Resource capacity) {
        this.maybeInitBuilder();
        if (capacity == null) {
            this.builder.clearEffectiveMinCapacity();
        }
        this.effMinResource = capacity;
    }

    public Resource getEffectiveMaxCapacity() {
        YarnProtos.QueueConfigurationsProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.effMaxResource != null) {
            return this.effMaxResource;
        }
        if (!p.hasEffectiveMaxCapacity()) {
            return null;
        }
        this.effMaxResource = this.convertFromProtoFormat(p.getEffectiveMaxCapacity());
        return this.effMaxResource;
    }

    public void setEffectiveMaxCapacity(Resource capacity) {
        this.maybeInitBuilder();
        if (capacity == null) {
            this.builder.clearEffectiveMaxCapacity();
        }
        this.effMaxResource = capacity;
    }

    private ResourcePBImpl convertFromProtoFormat(YarnProtos.ResourceProto p) {
        return new ResourcePBImpl(p);
    }

    private YarnProtos.ResourceProto convertToProtoFormat(Resource t) {
        return ProtoUtils.convertToProtoFormat(t);
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.QueueConfigurationsProto.newBuilder((YarnProtos.QueueConfigurationsProto)this.proto);
        }
        this.viaProto = false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this.getProto().equals((Object)((QueueConfigurationsPBImpl)((Object)((Object)((Object)this)).getClass().cast(other))).getProto());
        }
        return false;
    }

    public Resource getConfiguredMinCapacity() {
        YarnProtos.QueueConfigurationsProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.configuredMinResource != null) {
            return this.configuredMinResource;
        }
        if (!p.hasConfiguredMinCapacity()) {
            return null;
        }
        this.configuredMinResource = this.convertFromProtoFormat(p.getConfiguredMinCapacity());
        return this.configuredMinResource;
    }

    public void setConfiguredMinCapacity(Resource minResource) {
        this.maybeInitBuilder();
        if (minResource == null) {
            this.builder.clearConfiguredMinCapacity();
        }
        this.configuredMinResource = minResource;
    }

    public Resource getConfiguredMaxCapacity() {
        YarnProtos.QueueConfigurationsProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.configuredMaxResource != null) {
            return this.configuredMaxResource;
        }
        if (!p.hasConfiguredMaxCapacity()) {
            return null;
        }
        this.configuredMaxResource = this.convertFromProtoFormat(p.getConfiguredMaxCapacity());
        return this.configuredMaxResource;
    }

    public void setConfiguredMaxCapacity(Resource maxResource) {
        this.maybeInitBuilder();
        if (this.configuredMaxResource == null) {
            this.builder.clearConfiguredMaxCapacity();
        }
        this.configuredMaxResource = maxResource;
    }
}

