/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import java.io.IOException;
import org.opensearch.common.geo.GeoPoint;
import org.opensearch.common.xcontent.ObjectParser;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.search.aggregations.ParsedAggregation;
import org.opensearch.search.aggregations.metrics.GeoCentroid;
import org.opensearch.search.aggregations.metrics.InternalGeoCentroid;

public class ParsedGeoCentroid
extends ParsedAggregation
implements GeoCentroid {
    private GeoPoint centroid;
    private long count;
    private static final ObjectParser<ParsedGeoCentroid, Void> PARSER = new ObjectParser(ParsedGeoCentroid.class.getSimpleName(), true, ParsedGeoCentroid::new);
    private static final ObjectParser<GeoPoint, Void> GEO_POINT_PARSER = new ObjectParser(ParsedGeoCentroid.class.getSimpleName() + "_POINT", true, GeoPoint::new);

    @Override
    public GeoPoint centroid() {
        return this.centroid;
    }

    @Override
    public long count() {
        return this.count;
    }

    @Override
    public String getType() {
        return "geo_centroid";
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.centroid != null) {
            builder.startObject(InternalGeoCentroid.Fields.CENTROID.getPreferredName());
            builder.field(InternalGeoCentroid.Fields.CENTROID_LAT.getPreferredName(), this.centroid.lat());
            builder.field(InternalGeoCentroid.Fields.CENTROID_LON.getPreferredName(), this.centroid.lon());
            builder.endObject();
        }
        builder.field(InternalGeoCentroid.Fields.COUNT.getPreferredName(), this.count);
        return builder;
    }

    public static ParsedGeoCentroid fromXContent(XContentParser parser, String name) {
        ParsedGeoCentroid geoCentroid = (ParsedGeoCentroid)PARSER.apply(parser, null);
        geoCentroid.setName(name);
        return geoCentroid;
    }

    static {
        ParsedGeoCentroid.declareAggregationFields(PARSER);
        PARSER.declareObject((agg, centroid) -> {
            agg.centroid = centroid;
        }, GEO_POINT_PARSER, InternalGeoCentroid.Fields.CENTROID);
        PARSER.declareLong((agg, count) -> {
            agg.count = count;
        }, InternalGeoCentroid.Fields.COUNT);
        GEO_POINT_PARSER.declareDouble(GeoPoint::resetLat, InternalGeoCentroid.Fields.CENTROID_LAT);
        GEO_POINT_PARSER.declareDouble(GeoPoint::resetLon, InternalGeoCentroid.Fields.CENTROID_LON);
    }
}

