/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.dataframe.evaluation.classification;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.ml.dataframe.evaluation.EvaluationMetric;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ContextParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class AccuracyMetric
implements EvaluationMetric {
    public static final String NAME = "accuracy";
    private static final ObjectParser<AccuracyMetric, Void> PARSER = new ObjectParser("accuracy", true, AccuracyMetric::new);

    public static AccuracyMetric fromXContent(XContentParser parser) {
        return (AccuracyMetric)PARSER.apply(parser, null);
    }

    @Override
    public String getName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return Objects.hashCode(NAME);
    }

    public static class PerClassResult
    implements ToXContentObject {
        private static final ParseField CLASS_NAME = new ParseField("class_name", new String[0]);
        private static final ParseField ACCURACY = new ParseField("accuracy", new String[0]);
        private static final ConstructingObjectParser<PerClassResult, Void> PARSER = new ConstructingObjectParser("accuracy_per_class_result", true, a -> new PerClassResult((String)a[0], (Double)a[1]));
        private final String className;
        private final double accuracy;

        public PerClassResult(String className, double accuracy) {
            this.className = Objects.requireNonNull(className);
            this.accuracy = accuracy;
        }

        public String getClassName() {
            return this.className;
        }

        public double getAccuracy() {
            return this.accuracy;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(CLASS_NAME.getPreferredName(), this.className);
            builder.field(ACCURACY.getPreferredName(), this.accuracy);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PerClassResult that = (PerClassResult)o;
            return Objects.equals(this.className, that.className) && this.accuracy == that.accuracy;
        }

        public int hashCode() {
            return Objects.hash(this.className, this.accuracy);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), CLASS_NAME);
            PARSER.declareDouble(ConstructingObjectParser.constructorArg(), ACCURACY);
        }
    }

    public static class Result
    implements EvaluationMetric.Result {
        private static final ParseField CLASSES = new ParseField("classes", new String[0]);
        private static final ParseField OVERALL_ACCURACY = new ParseField("overall_accuracy", new String[0]);
        private static final ConstructingObjectParser<Result, Void> PARSER = new ConstructingObjectParser("accuracy_result", true, a -> new Result((List)a[0], (Double)a[1]));
        private final List<PerClassResult> classes;
        private final double overallAccuracy;

        public static Result fromXContent(XContentParser parser) {
            return (Result)PARSER.apply(parser, null);
        }

        public Result(List<PerClassResult> classes, double overallAccuracy) {
            this.classes = Collections.unmodifiableList(Objects.requireNonNull(classes));
            this.overallAccuracy = overallAccuracy;
        }

        @Override
        public String getMetricName() {
            return AccuracyMetric.NAME;
        }

        public List<PerClassResult> getClasses() {
            return this.classes;
        }

        public double getOverallAccuracy() {
            return this.overallAccuracy;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(CLASSES.getPreferredName(), this.classes);
            builder.field(OVERALL_ACCURACY.getPreferredName(), this.overallAccuracy);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result that = (Result)o;
            return Objects.equals(this.classes, that.classes) && this.overallAccuracy == that.overallAccuracy;
        }

        public int hashCode() {
            return Objects.hash(this.classes, this.overallAccuracy);
        }

        static {
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (ContextParser)PerClassResult.PARSER, CLASSES);
            PARSER.declareDouble(ConstructingObjectParser.constructorArg(), OVERALL_ACCURACY);
        }
    }
}

