/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.binsearch.impl;

import java.io.IOException;
import org.archive.util.binsearch.SeekableLineReaderFactory;
import org.archive.util.binsearch.impl.HTTPSeekableLineReader;
import org.archive.util.binsearch.impl.http.ApacheHttp43SLRFactory;
import org.archive.util.binsearch.impl.http.HTTPURLConnSLRFactory;

public abstract class HTTPSeekableLineReaderFactory
implements SeekableLineReaderFactory {
    protected String defaultURL;

    public abstract HTTPSeekableLineReader get(String var1) throws IOException;

    protected HTTPSeekableLineReaderFactory() {
    }

    public static HTTPSeekableLineReaderFactory getHttpFactory() {
        return HTTPSeekableLineReaderFactory.getHttpFactory(HttpLibs.APACHE_43);
    }

    public static HTTPSeekableLineReaderFactory getHttpFactory(HttpLibs type) {
        return HTTPSeekableLineReaderFactory.getHttpFactory(type, null);
    }

    public static HTTPSeekableLineReaderFactory getHttpFactory(String defaultURL) {
        return HTTPSeekableLineReaderFactory.getHttpFactory(HttpLibs.APACHE_43, defaultURL);
    }

    public static HTTPSeekableLineReaderFactory getHttpFactory(HttpLibs type, String defaultURL) {
        HTTPSeekableLineReaderFactory factory = null;
        switch (type.ordinal()) {
            case 1: {
                factory = new HTTPURLConnSLRFactory();
                break;
            }
            case 0: {
                factory = new ApacheHttp43SLRFactory();
            }
        }
        if (factory == null) {
            factory = new ApacheHttp43SLRFactory();
        }
        factory.defaultURL = defaultURL;
        return factory;
    }

    @Override
    public HTTPSeekableLineReader get() throws IOException {
        return this.get(this.defaultURL);
    }

    @Override
    public abstract void close() throws IOException;

    public abstract void setProxyHostPort(String var1);

    public abstract void setMaxTotalConnections(int var1);

    public abstract int getMaxTotalConnections();

    public abstract void setMaxHostConnections(int var1);

    public abstract int getMaxHostConnections();

    public abstract int getConnectionTimeoutMS();

    public abstract void setConnectionTimeoutMS(int var1);

    public abstract int getSocketTimeoutMS();

    public abstract void setSocketTimeoutMS(int var1);

    public abstract void setStaleChecking(boolean var1);

    public abstract boolean isStaleChecking();

    @Override
    public abstract long getModTime();

    @Override
    public void reload() {
    }

    public abstract void setNumRetries(int var1);

    public static enum HttpLibs {
        APACHE_43,
        URLCONN;

    }
}

