/*
 * Decompiled with CFR 0.152.
 */
package org.archive.streamcontext;

import java.io.IOException;
import org.archive.streamcontext.Stream;

public abstract class AbstractBufferingStream
implements Stream {
    protected static int DEFAULT_READ_SIZE = 4096;
    protected long offset = 0L;
    protected boolean closed = false;
    protected boolean atEof = false;
    protected byte[] buffer = null;
    protected int bufferRemaining = 0;
    protected int bufferCursor = 0;

    public AbstractBufferingStream() {
        this(0L, DEFAULT_READ_SIZE);
    }

    public AbstractBufferingStream(long offset) {
        this(offset, DEFAULT_READ_SIZE);
    }

    public AbstractBufferingStream(long offset, int readSize) {
        if (offset < 0L) {
            throw new IndexOutOfBoundsException();
        }
        this.offset = offset;
        this.buffer = new byte[readSize];
        this.closed = false;
        this.atEof = false;
        this.bufferRemaining = 0;
        this.bufferCursor = 0;
    }

    public abstract int doRead(byte[] var1, int var2, int var3) throws IOException;

    public abstract void doSeek(long var1) throws IOException;

    public abstract void doClose() throws IOException;

    @Override
    public boolean atEof() {
        return this.atEof;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Read after close()");
        }
        if (this.atEof) {
            return -1;
        }
        int amtRead = 0;
        while (len > 0) {
            if (this.bufferRemaining > 0) {
                int amtToCopy = Math.min(this.bufferRemaining, len);
                System.arraycopy(this.buffer, this.bufferCursor, b, off, amtToCopy);
                this.bufferCursor += amtToCopy;
                this.bufferRemaining -= amtToCopy;
                off += amtToCopy;
                len -= amtToCopy;
                amtRead += amtToCopy;
            }
            if (len <= 0) continue;
            int amtReadNow = this.doRead(this.buffer, 0, this.buffer.length);
            if (amtReadNow == -1) {
                this.atEof = true;
                break;
            }
            this.bufferCursor = 0;
            this.bufferRemaining = amtReadNow;
        }
        if (amtRead == 0) {
            amtRead = -1;
        } else {
            this.offset += (long)amtRead;
        }
        return amtRead;
    }

    @Override
    public long setOffset(long newOffset) throws IOException {
        if (this.offset < newOffset) {
            long amtToSkip = newOffset - this.offset;
            if (amtToSkip < (long)this.bufferRemaining) {
                this.bufferRemaining = (int)((long)this.bufferRemaining - amtToSkip);
                this.bufferCursor = (int)((long)this.bufferCursor + amtToSkip);
            } else {
                this.doSeek(newOffset);
                this.bufferRemaining = 0;
            }
            this.atEof = false;
        } else if (this.offset > newOffset) {
            long amtToReverse = this.offset - newOffset;
            if (amtToReverse < (long)this.bufferCursor) {
                this.bufferCursor = (int)((long)this.bufferCursor - amtToReverse);
                this.bufferRemaining = (int)((long)this.bufferRemaining + amtToReverse);
            } else {
                this.doSeek(newOffset);
                this.bufferRemaining = 0;
            }
            this.atEof = false;
        }
        this.offset = newOffset;
        return newOffset;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.doClose();
            this.closed = true;
        }
    }
}

