/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.gzip;

import java.io.IOException;
import java.io.OutputStream;
import org.archive.format.gzip.GZIPConstants;
import org.archive.format.gzip.GZIPFExtraRecord;
import org.archive.format.gzip.GZIPFExtraRecords;
import org.archive.format.gzip.GZIPFormatException;
import org.archive.format.gzip.GZIPStaticHeader;
import org.archive.util.ByteOp;
import org.archive.util.io.CRCOutputStream;

public class GZIPHeader
implements GZIPConstants {
    GZIPStaticHeader staticHeader = null;
    GZIPFExtraRecords records = null;
    byte[] fileName = null;
    int fileNameLength = -1;
    byte[] comment = null;
    int commentLength = -1;
    int crc = -1;

    public GZIPHeader() {
        this.staticHeader = new GZIPStaticHeader();
        this.records = null;
        this.fileName = null;
        this.fileNameLength = 0;
        this.comment = null;
        this.commentLength = 0;
        this.crc = -1;
    }

    public GZIPHeader(GZIPStaticHeader staticHeader) {
        this.staticHeader = staticHeader;
        this.records = null;
        this.fileName = null;
        this.fileNameLength = 0;
        this.comment = null;
        this.commentLength = 0;
        this.crc = -1;
    }

    public GZIPStaticHeader getStaticHeader() {
        return this.staticHeader;
    }

    public byte[] getFileName() {
        return this.fileName;
    }

    public byte[] getComment() {
        return this.comment;
    }

    public long getFNameLength() {
        return this.fileNameLength;
    }

    public int getHeaderCRC() {
        return this.crc;
    }

    public void setFName(byte[] fileName) {
        if (fileName != null) {
            this.fileName = ByteOp.copy(fileName);
            this.staticHeader.setFNameFlag(true);
            this.fileNameLength = fileName.length;
        } else {
            this.fileName = null;
            this.staticHeader.setFNameFlag(false);
            this.fileNameLength = 0;
        }
        this.crc = -1;
    }

    public long getCommentLength() {
        return this.commentLength;
    }

    public void setFComment(byte[] comment) {
        if (comment != null) {
            this.comment = ByteOp.copy(comment);
            this.staticHeader.setFCommentFlag(true);
            this.commentLength = comment.length;
        } else {
            this.comment = null;
            this.staticHeader.setFCommentFlag(false);
            this.commentLength = 0;
        }
        this.crc = -1;
    }

    public void replaceRecord(byte[] name, byte[] value) throws GZIPFormatException {
        if (this.records != null) {
            this.removeAllRecords(name);
        }
        this.addRecord(name, value);
    }

    public void removeAllRecords(byte[] name) {
        int removed = 0;
        if (this.records != null) {
            int kept = 0;
            for (int i = 0; i < this.records.size(); ++i) {
                if (((GZIPFExtraRecord)this.records.get(i)).matchesName(name)) {
                    this.records.remove(i);
                    ++removed;
                    --i;
                    continue;
                }
                ++kept;
            }
            if (kept == 0) {
                this.records = null;
                this.staticHeader.setFExtraFlag(false);
            }
        }
        if (removed > 0) {
            this.crc = -1;
        }
    }

    public void addRecord(byte[] name, long intVal) throws GZIPFormatException {
        if (this.records == null) {
            this.records = new GZIPFExtraRecords();
        }
        this.records.add(new GZIPFExtraRecord(name, intVal));
        this.staticHeader.setFExtraFlag(true);
        this.crc = -1;
    }

    public void addRecord(byte[] name, byte[] value) throws GZIPFormatException {
        if (this.records == null) {
            this.records = new GZIPFExtraRecords();
        }
        this.records.add(new GZIPFExtraRecord(name, value));
        this.staticHeader.setFExtraFlag(true);
        this.crc = -1;
    }

    public GZIPFExtraRecord getRecord(int i) {
        if (this.records == null || this.records.isEmpty()) {
            throw new IndexOutOfBoundsException();
        }
        return (GZIPFExtraRecord)this.records.get(i);
    }

    public int getRecordCount() {
        return this.records == null ? 0 : this.records.size();
    }

    public GZIPFExtraRecord getRecord(byte[] name) {
        if (this.records != null) {
            for (GZIPFExtraRecord rec : this.records) {
                if (!rec.matchesName(name)) continue;
                return rec;
            }
        }
        return null;
    }

    public long getIntRecord(byte[] name) {
        if (this.records != null) {
            for (GZIPFExtraRecord rec : this.records) {
                if (!rec.matchesName(name)) continue;
                return ByteOp.bytesToInt(rec.getValue());
            }
        }
        return -1L;
    }

    public int getLength() {
        int size = this.staticHeader.getLength();
        if (this.records != null) {
            size += this.records.getByteLength();
        }
        size += this.fileNameLength;
        size += this.commentLength;
        if (this.staticHeader.isFHCRCSet()) {
            size += 2;
        }
        return size;
    }

    public void writeBytes(OutputStream os) throws IOException {
        OutputStream origOS = os;
        if (this.staticHeader.isFHCRCSet() && this.crc == -1) {
            os = new CRCOutputStream(origOS);
        }
        this.staticHeader.writeTo(os);
        if (this.staticHeader.isFExtraSet()) {
            this.records.writeTo(os);
        }
        if (this.staticHeader.isFNameSet()) {
            os.write(this.fileName);
        }
        if (this.staticHeader.isFCommentSet()) {
            os.write(this.comment);
        }
        if (this.staticHeader.isFHCRCSet()) {
            if (this.crc == -1) {
                this.crc = (int)((CRCOutputStream)os).getCRCValue() & 0xFFFF;
            }
            ByteOp.writeShort(origOS, this.crc);
        }
    }

    public static boolean isValidCompressionMethod(int cm) {
        return cm == 8;
    }
}

