/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.nutch.util.TrieStringMatcher;

public class PrefixStringMatcher
extends TrieStringMatcher {
    public PrefixStringMatcher(String[] prefixes) {
        for (int i = 0; i < prefixes.length; ++i) {
            this.addPatternForward(prefixes[i]);
        }
    }

    public PrefixStringMatcher(Collection<String> prefixes) {
        Iterator<String> iter = prefixes.iterator();
        while (iter.hasNext()) {
            this.addPatternForward(iter.next());
        }
    }

    @Override
    public boolean matches(String input) {
        TrieStringMatcher.TrieNode node = this.root;
        for (int i = 0; i < input.length(); ++i) {
            if ((node = node.getChild(input.charAt(i))) == null) {
                return false;
            }
            if (!node.isTerminal()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String shortestMatch(String input) {
        TrieStringMatcher.TrieNode node = this.root;
        for (int i = 0; i < input.length(); ++i) {
            if ((node = node.getChild(input.charAt(i))) == null) {
                return null;
            }
            if (!node.isTerminal()) continue;
            return input.substring(0, i + 1);
        }
        return null;
    }

    @Override
    public String longestMatch(String input) {
        TrieStringMatcher.TrieNode node = this.root;
        String result = null;
        for (int i = 0; i < input.length() && (node = node.getChild(input.charAt(i))) != null; ++i) {
            if (!node.isTerminal()) continue;
            result = input.substring(0, i + 1);
        }
        return result;
    }

    public static final void main(String[] argv) {
        String[] prefixes = new String[]{"abcd", "abc", "aac", "baz", "foo", "foobar"};
        PrefixStringMatcher matcher = new PrefixStringMatcher(prefixes);
        String[] tests = new String[]{"a", "ab", "abc", "abcdefg", "apple", "aa", "aac", "aaccca", "abaz", "baz", "bazooka", "fo", "foobar", "kite"};
        for (int i = 0; i < tests.length; ++i) {
            System.out.println("testing: " + tests[i]);
            System.out.println("   matches: " + matcher.matches(tests[i]));
            System.out.println("  shortest: " + matcher.shortestMatch(tests[i]));
            System.out.println("   longest: " + matcher.longestMatch(tests[i]));
        }
        int iterations = 1000;
        System.out.println("Testing thread-safety (NUTCH-2585) with " + iterations + " iterations:");
        List<String> testsList = Arrays.asList(tests);
        for (int i = 0; i < iterations; ++i) {
            matcher = new PrefixStringMatcher(prefixes);
            Collections.shuffle(testsList);
            try {
                long count = testsList.parallelStream().filter(matcher::matches).count();
                System.out.print(String.format("Cycle %4d : %d matches\r", i, count));
                continue;
            }
            catch (Exception e) {
                System.out.println("");
                throw e;
            }
        }
        System.out.println("");
    }
}

