/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.metadata;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.nutch.crawl.NutchWritable;
import org.apache.nutch.metadata.Metadata;

public class MetaWrapper
extends NutchWritable {
    private Metadata metadata;

    public MetaWrapper() {
        this.metadata = new Metadata();
    }

    public MetaWrapper(Writable instance, Configuration conf) {
        super(instance);
        this.metadata = new Metadata();
        this.setConf(conf);
    }

    public MetaWrapper(Metadata metadata, Writable instance, Configuration conf) {
        super(instance);
        if (metadata == null) {
            metadata = new Metadata();
        }
        this.metadata = metadata;
        this.setConf(conf);
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void addMeta(String name, String value) {
        this.metadata.add(name, value);
    }

    public void setMeta(String name, String value) {
        this.metadata.set(name, value);
    }

    public String getMeta(String name) {
        return this.metadata.get(name);
    }

    public String[] getMetaValues(String name) {
        return this.metadata.getValues(name);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.metadata = new Metadata();
        this.metadata.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.metadata.write(out);
    }
}

